<?php

/**
 * PluginArticle form.
 *
 * @package    ##PROJECT_NAME##
 * @subpackage filter
 * @author     ##AUTHOR_NAME##
 * @version    SVN: $Id: sfDoctrineFormFilterPluginTemplate.php 23810 2009-11-12 11:07:44Z Kris.Wallsmith $
 */
abstract class PluginArticleFormFilter extends BaseArticleFormFilter
{

  public function setup()
  {
    $this->setWidgets(array(
        'creator_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('multiple' => true, 'model' => $this->getRelatedModelName('sfGuardUser'))),
        'layout_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('multiple' => true, 'model' => $this->getRelatedModelName('Layout'))),
        'is_displayed' => new sfArtWidgetFormFilterBoolRadio(),
        'categories_list' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('multiple' => true, 'model' => 'Category', 'table_method' => 'getTranslationList')),
        'tags_list' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('multiple' => true, 'model' => 'Tag', 'table_method' => 'getTranslationList')),
        'permissions_list' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('multiple' => true, 'model' => 'sfGuardPermission')),
        'groups_list' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('multiple' => true, 'model' => 'sfGuardGroup')),
        'preferred_articles_list' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('multiple' => true, 'model' => 'Article', 'table_method' => 'getTranslationList')),
        'views' => new sfArtWidgetFormIntervalFilterInput(),
        'article_blog_categories_list' => new sfArtWidgetFormDoctrineJQueryMultiselect(array('multiple' => true, 'model' => 'ArticleBlogCategory')),
        'title' => new sfArtWidgetFormFilterInput(array('with_empty' => false)),
        'description' => new sfArtWidgetFormFilterInput(array('with_empty' => false)),
    ));

    $this->setValidators(array(
        'creator_id' => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('sfGuardUser'), 'column' => 'id')),
        'layout_id' => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('Layout'), 'column' => 'id')),
        'is_displayed' => new sfArtValidatorFormLogic(array('with_empty' => true)),
        'views' => new sfValidatorSchemaFilter('text', new sfValidatorNumber(array('required' => false))),
        'categories_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'Category', 'required' => false)),
        'tags_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'Tag', 'required' => false)),
        'permissions_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'sfGuardPermission', 'required' => false)),
        'groups_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'sfGuardGroup', 'required' => false)),
        'preferred_articles_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'Article', 'required' => false)),
        'article_blog_categories_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'ArticleBlogCategory', 'required' => false)),
        'title' => new sfValidatorPass(array('required' => false)),
        'description' => new sfValidatorPass(array('required' => false)),
    ));
    
    if (artSettings::isBackendApp())
      unset($this['article_blog_categories_list']);
    
    $this->widgetSchema->setNameFormat('article_filters[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
  }

  public function addViewsColumnQuery(Doctrine_Query $query, $field, $values)
  {
    return sfArtWidgetFormIntervalFilterInput::addColumnQuery($query, $field, $values);
  }
  
  public function addTitleColumnQuery(Doctrine_Query $query, $field, $values)
  {
    if (is_array($values) && isset($values['text']) && '' != $values['text'])
    {
      $rootAlias = $query->getRootAlias();
      
      $query->addWhere($rootAlias.'.id IN (SELECT t.id FROM ArticleTranslation t WHERE t.lang = ? and t.title like ?)', array($this->getUser()->getCulture(),'%' . $values['text'] . '%'));
    }
  }
  
  public function addDescriptionColumnQuery(Doctrine_Query $query, $field, $values)
  {
    if (is_array($values) && isset($values['text']) && '' != $values['text'])
    {
      $rootAlias = $query->getRootAlias();
      
      $query->addWhere($rootAlias.'.id IN (SELECT tr.id FROM ArticleTranslation tr WHERE tr.lang = ? and tr.description like ?)', array($this->getUser()->getCulture(),'%' . $values['text'] . '%'));
    }
  }
  
  public function getFields()
  {
    return parent::getFields() + array('title' => 'Text', 'description' => 'Text');
  }

}
