<?php

/**
 * Description of PluginArticleAdvancedForm
 * Formularz zaawansowany
 */
class PluginArticleAdvancedForm extends BaseArticleForm {

  public function setup() {
    $hasTitleImage = $this->object->hasTitleImageForForm();
    $hasBigImage = $this->object->hasBigImage();

    $this->setWidgets(array(
        'id' => new sfWidgetFormInputHidden(),
        'editor_id' => new sfWidgetFormInputHidden(),
        'layout_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('multiple' => false, 'model' => 'Layout', 'add_empty' => false, 'table_method' => 'getArticleLayouts')),
        'is_displayed' => new sfArtWidgetFormLogic(),
        'start_at' => new sfArtWidgetFormInputJQueryDate(array('min_year' => date('Y'), 'max_year' => (date('Y') + 5))),
        'expire_at' => new sfArtWidgetFormInputJQueryDate(array('min_year' => date('Y'), 'max_year' => (date('Y') + 5))),
        'title_image' => new sfArtWidgetFormInputAjaxFileEditable(array(
            'file_src' => $hasTitleImage ? Article::getTitleImagePath() . $this->getObject()->get('title_image') : false,
            'edit_mode' => true,
            'is_image' => true,
            'with_delete' => $hasTitleImage)),
        'big_image' => new sfArtWidgetFormInputAjaxFileEditable(array(
            'file_src' => $hasBigImage ? Article::getBigImagePath() . $this->getObject()->get('big_image') : false,
            'edit_mode' => true,
            'is_image' => true,
            'with_delete' => $hasBigImage)),
        'title_image_label' => new sfArtWidgetFormInputText(),
        'source' => new sfArtWidgetFormInputText(),
        'categories_list' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('multiple' => true, 'model' => 'Category', 'table_method' => 'getTranslationList')),
        'tags_list' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('multiple' => true, 'model' => 'Tag', 'table_method' => 'getTranslationList')),
        'permissions_list' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('multiple' => true, 'model' => 'sfGuardPermission')),
        'groups_list' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('multiple' => true, 'model' => 'sfGuardGroup')),
        'preferred_articles_list' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('multiple' => true, 'model' => 'Article', 'table_method' => 'getArticlesWithoutOne')),
    ));

    $this->setValidators(array(
        'id' => new sfValidatorChoice(array('choices' => array($this->getObject()->get('id')), 'empty_value' => $this->getObject()->get('id'), 'required' => false)),
        'editor_id' => new sfValidatorPass(),
        'layout_id' => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('Layout'))),
        'is_displayed' => new sfArtValidatorFormLogic(),
        'start_at' => new sfValidatorDateTime(array('required' => false)),
        'expire_at' => new sfValidatorDateTime(array('required' => false)),
        'title_image' => new sfArtValidatorFile(array(
            'path' => Article::getTitleImageAbsolutePath(),
            'max_size' => 4194304,
            'resize_size_width' => sfConfig::get('app_art_cms_plugin_article_title_image_width', 150),
            'resize_size_height' => sfConfig::get('app_art_cms_plugin_article_title_image_height', 150),
            'required' => false
        )),
        'title_image_label' => new sfValidatorString(array('max_length' => 255, 'required' => false)),
        'title_image_delete' => new sfValidatorBoolean(),
        'big_image' => new sfArtValidatorFile(array(
            'path' => Article::getBigImageAbsolutePath(),
            'max_size' => 4194304,
            'resize_size' => sfConfig::get('app_art_cms_plugin_article_title_image_size', 500),
            'required' => false
        )),
        'big_image_delete' => new sfValidatorBoolean(),
        'source' => new sfValidatorString(array('max_length' => 500, 'required' => false)),
        'categories_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'Category', 'required' => false)),
        'tags_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'Tag', 'required' => false)),
        'permissions_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'sfGuardPermission', 'required' => false)),
        'groups_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'sfGuardGroup', 'required' => false)),
        'preferred_articles_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'Article', 'required' => false)),
    ));


    if (artSettings::isDevEnvironment()) {
      $this->widgetSchema['unique_name'] = new sfArtWidgetFormInputText();
      $this->validatorSchema['unique_name'] = new sfValidatorString(array('max_length' => 100, 'required' => false));
    }

    $this->embedI18nWithLabels();

    $this->widgetSchema->setNameFormat('article[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
  }

  public function updateDefaultsFromObject() {
    parent::updateDefaultsFromObject();

    if (isset($this->widgetSchema['categories_list'])) {
      $defaults = array();
      foreach ($this->object->getArticleCategories() as $articleCategory)
        $defaults[] = $articleCategory->getCategoryId();
      artDebug::logWarning(print_r($defaults, true));
      $this->setDefault('categories_list', $defaults);
    }

    if (isset($this->widgetSchema['article_blog_categories_list'])) {
      $this->setDefault('article_blog_categories_list', $this->object->ArticleBlogCategories->getPrimaryKeys());
    }
  }

  public function getTranslationLevelsArray() {
    return array(
        array('meta_title'),
        array('meta_description', 'meta_keywords')
    );
  }

  public function getLevelsArray() {
    return array(
        array('layout_id', 'is_displayed'),
        array('categories_list', 'unique_name'),
        array('start_at', 'expire_at'),
        array('title_image', 'big_image'),
        array('title_image_label', 'source'),
        'permissions_groups' => array('permissions_list', 'groups_list'),
        array('preferred_articles_list', 'tags_list'),
    );
  }

  public function bind(array $taintedValues = null, array $taintedFiles = null) {
    if (isset($taintedValues['title_image']) || isset($taintedValues['big_image'])) {
      $photoName = $taintedValues['id'] . '_' . Slug::slugify($this->getObject()->getTitle());

      if (isset($taintedValues['title_image']))
        $this->validatorSchema['title_image']->setNewName($photoName);

      if (isset($taintedValues['big_image']) && ArticleSettings::hasBigImage())
        $this->validatorSchema['big_image']->setNewName($photoName);
    }

    if ((isset($taintedValues['start_at']) && $taintedValues['start_at'] != '') || (isset($taintedValues['expire_at']) && $taintedValues['expire_at'] != '')) {
      $this->validatorSchema['start_at'] = new sfValidatorDateTime();
      $this->validatorSchema['expire_at'] = new sfValidatorDateTime();
    }

    $translations = $this->getObject()->__get('Translation');

    foreach ($this->getPreferredCulture() as $culture)
      foreach ($translations[$culture]->toArray() as $field => $value)
        if (!isset($taintedValues[$culture][$field]))
          $taintedValues[$culture][$field] = $value;

    parent::bind($taintedValues, $taintedFiles);
  }

  public function save($con = null) {
    artTask::clearCache();

    $this->values['editor_id'] = BaseForm::getUserId();

    if (isset($this->values['created_at']))
      $this->values['created_at'] = date('Y-m-d H:i:S', strtotime($this->values['created_at']));
    else
      $this->values['created_at'] = artDate::today();

    if (isset($this->values['updated_at']))
      $this->values['updated_at'] = date('Y-m-d H:i:S', strtotime($this->values['updated_at']));
    else
      $this->values['updated_at'] = artDate::today();

    if (isset($this->values['start_at']))
      $this->values['start_at'] = date('Y-m-d', strtotime($this->values['start_at'])) . ' 00:00:00';
    else
      unset($this->values['start_at']);
    if (isset($this->values['expire_at']))
      $this->values['expire_at'] = date('Y-m-d', strtotime($this->values['start_at'])) . ' 23:59:59';
    else
      unset($this->values['expire_at']);
     
    $this->object = parent::save($con);
    $str = "";
    
    foreach ($this->object->getArticleCategories() as $category)
      $categories[] = $category->getCategoryId();
    
    if (isset($categories))
      $str = implode(',', $categories);
       
    $articleId = $this->object->getId();
    $str = trim($str);
    
    if ($str != '')
      {
      $quer = "call set_article_order('$str','$articleId')";
      artQuery::executeSql($quer);}
    
    return $this->object;
  }

  public function saveCategoriesList($con = null) {
    if (!$this->isValid())
      throw $this->getErrorSchema();

    if (!isset($this->widgetSchema['categories_list']))
      return;

    if (null === $con)
      $con = $this->getConnection();

    $existing = array();
    foreach ($this->object->getArticleCategories() as $category)
      $existing[] = $category->getCategoryId();

    $values = $this->getValue('categories_list');

    if (!$this->validatorSchema['categories_list']->getOption('multiple', true))
      $values = (array) $values;
    else if (!is_array($values))
      $values = array();

    $unlink = array_diff($existing, $values);

    if (count($unlink)) {
      $this->object->unlink('Categories', array_values($unlink));
      Article::deleteCategoriesList($unlink);
    }

    $link = array_diff($values, $existing);

    if (count($link))
    {
      $this->object->link('Categories', array_values($link));
    }
  }
}

