<?php

/**
 * Description of ArticleBlogAdvancedForm
 *
 
 */
class PluginArticleBlogAdvancedForm extends PluginArticleAdvancedForm
{
  public function configure()
  {
    parent::configure();
    $this->setWidget('categories_list', new sfArtWidgetFormDoctrineJQueryMultiSelect(array('multiple' => true, 'model' => 'Category', 'table_method' => 'getBlogList')));
    $this->setValidator('categories_list', new sfValidatorDoctrineChoice(
                array(
                    'multiple' => true,
                    'model' => 'Category',
                    'required' => false,
                    'query' => Doctrine::getTable('Category')->getBlogList()
                )));
    $this->setWidget('created_at', new sfArtWidgetFormInputJQueryDateTime());
    $this->setValidator('created_at', new sfValidatorDateTime(array('required' => false)));
  }
  
  public function getLevelsArray()
  {
    return array(
        array('layout_id', 'is_displayed'),
        array('categories_list', 'created_at'), 
        array('permissions_list'),
        array('title_image', 'big_image'), 
        array('title_image_label'), 
    );
  }
  
}
