<?php

class PluginArticleInlineForm extends PluginArticleForm {


  public function configure() {

    parent::configure();

    $this->widgetSchema->setNameFormat('article_inline[%s]');
    $this->setupInheritance();
  }

//  protected function getAvailableFields() {
//    return array('id');
//  }

  public function embedI18n($cultures, $decorator = null) {
    if (!$this->isI18n()) {
      throw new sfException(sprintf('The model "%s" is not internationalized.', $this->getModelName()));
    }

    $culture = sfContext::getInstance()->getUser()->getCulture();

    $class = $this->getI18nFormClass();
    $i18nObject = $this->getObject()->Translation[$culture];
    $i18n = new $class($i18nObject);

    if (false === $i18nObject->exists()) {
      unset($i18n[$this->getI18nModelPrimaryKeyName()], $i18n[$this->getI18nModelI18nField()]);
    }

    $this->embedForm($culture, $i18n, $decorator);
  }

  protected function initTranslationFields() {

    $lang = sfContext::getInstance()->getUser()->getCulture();
    $availableTranslationFields = $this->getAvailableTranslationFields();

   foreach ($this->widgetSchema[$lang]->getFields() as $field => $widget) {
      if (!in_array($field, $availableTranslationFields)) {
        unset($this->widgetSchema[$lang][$field]);
        unset($this->validatorSchema[$lang][$field]);
      } else {
        $this->validatorSchema[$lang][$field]->setOption('required', false);
      }
    }
  }
  
    protected function initCultureLabels() {
//    foreach ($this->getPreferredCulture() as $lang) {
//      if ($this->hasCultureLabels()) {
//        $this->widgetSchema->setLabel($lang, $this->getCultureLabel($lang));
//      } else {
//        $this->widgetSchema->setLabel($lang, false);
//      }
//    }
  }
}