<?php

/**
 * Klasa formularza artykulu wykorzystywana w module frontend_management.
 * 
 * @package artCmsPlusPlugin
 *
 */
abstract class PluginArticleLayoutForm extends BaseArticleForm {

    public function configure() {
        $this->useFields(array('id', 'layout_id'));

        $query = Doctrine::getTable('Layout')->getLayoutsByModule($this->getOption('module'));
        $this->setWidget('layout_id', new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('Layout'), 'add_empty' => false, 'query' => $query)));


        $this->getWidgetSchema()->setLabel('layout_id', __('Wygląd strony'));
        foreach ($this->getFormFieldSchema() as $name => $field) {
            $this->getWidget($name)->setAttribute('class', 'form-control');
        }

        $this->disableRequiredsFieldText();
        $this->getWidgetSchema()->setFormFormatterName('Flaty');
    }

    public function save($con = null) {
        parent::save($con);

        $article = $this->getObject();
        $id = $article->getId();

        try {
            foreach ($article->getArticlePhotoes() as $photo) {

                $fileName = $photo->getOriginalImage();

                $targetDir = sfConfig::get('sf_upload_dir') . DIRECTORY_SEPARATOR . 'articles' . DIRECTORY_SEPARATOR . $id . DIRECTORY_SEPARATOR . 'original';
                $filePath = $targetDir . DIRECTORY_SEPARATOR . $fileName;

                if (file_exists($filePath)) {

                    foreach (GalleryManagement::getPhotoSizes($article) as $size => $options) {
                        $targetDir = sfConfig::get('sf_upload_dir') . DIRECTORY_SEPARATOR . 'articles' . DIRECTORY_SEPARATOR . $article->getId() . DIRECTORY_SEPARATOR . $size . DIRECTORY_SEPARATOR . $fileName;

                        artPhotoConverter::resizePhoto(
                                $options, $filePath, $targetDir
                        );
                    }
                }
            }
        } catch (Exception $ex) {
            sfContext::getInstance()->getLogger()->err("Wystapił błąd poczas konwersji zdjęć, zdjęcia mogą być w niepoprwanych rozmiarach");
        }
    }

    public function getIcon() {
        return 'megaicon1-layout';
    }

}
