<?php

/**
 * Klasa formularza metatagow artykulu wykorzystywana w module frontend_management.
 * 
 * @package artCmsPlusPlugin
 *
 */
abstract class PluginArticleMetaForm extends PluginArticleForm {

  public function configure() {
    parent::configure();
    $this->useFields(array('id'));

    foreach ($this->getFormFieldSchema() as $name => $field) {
      $this->getWidget($name)->setAttribute('class', 'form-control');
    }

    $this->disableRequiredsFieldText();
    // Niestety musimy ponownie embedowac formularze, zeby ustawily sie pola
    $this->embedI18nWithLabels();
    $this->widgetSchema->setNameFormat('article_meta[%s]');
    $this->getWidgetSchema()->setFormFormatterName('Flaty');

    unset($this->widgetSchema['slug']);
    unset($this->validatorSchema['slug']);
  }

  protected function useTranslationFields() {
    return array('id', 'meta_title', 'meta_description', 'meta_keywords', 'lang');
  }
    public function getIcon() {
        return 'megaicon1-share';
    }
}
