<?php

/**
 * Klasa formularza kategorii wykorzystywana w module frontend_management.
 * 
 * @package artCmsPlusPlugin
 *
 */
abstract class PluginCategoryLayoutForm extends BaseCategoryForm {

    public function configure() {
        $this->useFields(array('id', 'layout_id'));

        $query = Doctrine::getTable('Layout')->getLayoutsByModule($this->getOption('module'));

        $this->setWidget('layout_id'
                , new sfWidgetFormDoctrineChoice(
                array('model' => $this->getRelatedModelName('Layout'), 'add_empty' => false, 'query' => $query), array('class' => 'chosen-select')));


        foreach ($this->getFormFieldSchema() as $name => $field) {
            $this->getWidget($name)->setAttribute('class', 'form-control');
        }
        $this->getWidgetSchema()->setLabel('layout_id', __('Wygląd strony'));
        $this->widgetSchema->setHelp('slug', 'Will be generated automatically.');
        $this->disableRequiredsFieldText();
        $this->getWidgetSchema()->setFormFormatterName('Flaty');
    }

    public function getIcon() {
        return 'megaicon1-layout';
    }

}
