<?php

abstract class PluginContactForm extends BaseForm
{
   public function configure()
  {
     
    $this->setWidgets(array(
        'name' => new sfWidgetFormInput(array(), array()),
        'email' => new sfWidgetFormInput(array(), array()),
        'message' => new sfWidgetFormTextarea(array(), array('rows' => '2' , 'class' => 'no-ckeditor')),
    ));

    $this->setValidators(array(
        'name'=> new sfValidatorString(array('required' => true)),
        'email'=> new sfValidatorEmail(array('required' => true)),
        'message' => new sfValidatorString(array('required' => true))
    ));

    $this->widgetSchema->setNameFormat('contact[%s]');
    
    $custom_decorator = new sfWidgetFormSchemaFormatterDefault($this->getWidgetSchema());
    $this->getWidgetSchema()->addFormFormatter('Default', $custom_decorator);
    $this->getWidgetSchema()->setFormFormatterName('Default');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
  }
}