<?php

/**
 * PluginMenuItem form.
 *
 * @package    ##PROJECT_NAME##
 * @author     ##AUTHOR_NAME##
 */
abstract class PluginMenuItemArticleForm extends BaseMenuItemForm {

  public function configure() {
    $this->useFields(array('id'));

    if ($this->getOption('task') == 'add') {
      $this->setWidget('info', new artWidgetFormShowText(
              __('Pozycja będzie prowadzić do nowego Artykułu. Jeśli chcesz, aby prowadziła do już istniejącego wybierz go z poniższej listy.')
      ));
    } else {
      $this->setWidget('info', new artWidgetFormShowText(
              __('Pozycja prowadzi do wybranego niżej Artykułu. Możesz wybrać dowolny istniejący Artykuł.')
      ));
    }
    $this->setValidator('info', new sfValidatorPass());

    $articles = Doctrine::getTable('Article')->getArticlesForMenuItem($this->getUser()->getCulture(), ($this->getOption('task') == 'add'));
    $this->setWidget('article_id', new sfWidgetFormChoice(
            array('multiple' => false, 'choices' => $articles)
            , array('class' => 'chosen-select', 'data-placeholder' => 'Wybierz artykuł...')
    ));
    $this->setValidator('article_id', new sfValidatorChoice(array('multiple' => false, 'choices' => array_keys($articles))));
    $this->setDefault('article_id', $this->getObject()->getUrl());
    $this->widgetSchema->setLabel('article_id', false);

    $this->embedI18nWithLabels();
    foreach ($this->getEmbeddedForms() as $name => $form) {
      unset($this->widgetSchema[$name]['url']);
    }

    foreach ($this->getFormFieldSchema() as $name => $field) {
      $this->getWidget($name)->setAttribute('class', 'form-control');
    }

    $this->setWidget('use_title', new artBoostrapWidgetFormCheckbox(
            array(
        'label' => 'Pobierz nazwę pozycji z tytułu Artykułu',
            ), array(
        'onclick' => '$(this).parent().parent().parent().parent().children(\'.shortcode_tabs\').toggle();',
        'form-embedded-toggle' => 'true',
        'class' => 'checkbox'
            )
    ));
    $this->setValidator('use_title', new sfValidatorInteger(array('required' => false)));

    if ($this->getObject()->getUrlType() == GroupMenuFunctions::URL_ARTICLE_TITLE || $this->getOption('task') == 'add') {
      $this->getWidget('use_title')->setAttribute('checked', 'checked');
    }

    $this->disableRequiredsFieldText();
    $this->getWidgetSchema()->setFormFormatterName('Flaty');
  }

  public function updateObject($values = null) {
    $object = parent::updateObject($values);

    $object->setUrlType(GroupMenuFunctions::URL_ARTICLE);
    if (isset($values['use_title']) && $values['use_title'] == 1) {
      $object->setUrlType(GroupMenuFunctions::URL_ARTICLE_TITLE);
    }

    if ($values['article_id'] == 0) {
      // Wybrano stworzenie nowego artykułu
      $articleUniqueName = ArtConfiguration::getConfig('basic_article_example', 'basic-article-example');
      $articleExample = Doctrine::getTable('Article')->getArticleDataForCopy($articleUniqueName);
      if ($articleExample) {
        $article = new Article();
        // Nie mozemy uzyc $article->copy() bo niestety jest wyciek pamieci
        $article->copyFromArray($articleExample);
        $article->setCreatorId(sfContext::getInstance()->getUser()->getId());
        $article->setEditorId(sfContext::getInstance()->getUser()->getId());
        $article->setIsDisplayed(1);
        if (!is_null($this->getOption('category_id', null))) {
          $article->link('Categories', $this->getOption('category_id'));
        }
        $article->save();
      } else {
        throw new sfException('Brak artykulu o unique_name "' . $articleUniqueName . '" do skopiowania.');
      }
      $values['article_id'] = $article->getId();
    } else {
      $article = Doctrine::getTable('Article')->findOneById($values['article_id']);
    }

    foreach ($this->getEmbeddedForms() as $form) {
      $form->getObject()->set('url', $values['article_id']);
      if ($object->getUrlType() == GroupMenuFunctions::URL_ARTICLE_TITLE) {
        $form->getObject()->set('title', $article->getTitle());
      }
    }

    return $object;
  }

  public function getIcon() {
    return 'megaicon1-lock';
  }

}
