<?php

/**
 * PluginMenuItem form.
 *
 * @package    ##PROJECT_NAME##
 * @author     ##AUTHOR_NAME##
 */
abstract class PluginMenuItemCategoryForm extends BaseMenuItemForm {

  public function configure() {
    $this->useFields(array('id'));

    if ($this->getOption('task') == 'add') {
      $this->setWidget('info', new artWidgetFormShowText(
              __('Pozycja będzie prowadzić do nowej Kategorii. Jeśli chcesz, aby prowadziła do już istniejącej wybierz go z poniższej listy.')
      ));
    } else {
      $this->setWidget('info', new artWidgetFormShowText(
              __('Pozycja prowadzi do wybranego niżej Kategorii. Możesz wybrać dowolną istniejącą Kategorię.')
      ));
    }
    $this->setValidator('info', new sfValidatorPass());


    $categories = Doctrine::getTable('Category')->getCategoriesForMenuItem($this->getUser()->getCulture(), ($this->getOption('task') == 'add'));
    $this->setWidget('category_id', new sfWidgetFormChoice(
            array('multiple' => false, 'choices' => $categories)
            , array('class' => 'chosen-select')
    ));

    $this->setValidator('category_id', new sfValidatorChoice(array('multiple' => false, 'choices' => array_keys($categories))));
    $this->setDefault('category_id', $this->getObject()->getUrl());
    $this->widgetSchema->setLabel('category_id', false);

    $this->embedI18nWithLabels();
    foreach ($this->getEmbeddedForms() as $name => $form) {
      unset($this->widgetSchema[$name]['url']);
    }

    foreach ($this->getFormFieldSchema() as $name => $field) {
      $this->getWidget($name)->setAttribute('class', 'form-control');
    }

    $this->setWidget('use_title', new artBoostrapWidgetFormCheckbox(
            array(
                'label' => 'Pobierz nazwę pozycji z tytułu Kategorii'
            ), array(
        'onclick' => '$(this).parent().parent().parent().parent().children(\'.shortcode_tabs\').toggle();',
        'form-embedded-toggle' => 'true',
        'class' => 'checkbox',
            )
    ));
    $this->setValidator('use_title', new sfValidatorInteger(array('required' => false)));

    if ($this->getObject()->getUrlType() == GroupMenuFunctions::URL_CATEGORY_TITLE || $this->getOption('task') == 'add') {
      $this->getWidget('use_title')->setAttribute('checked', 'checked');
    }

    $this->disableRequiredsFieldText();
    $this->getWidgetSchema()->setFormFormatterName('flaty');
  }

  public function updateObject($values = null) {
    $object = parent::updateObject($values);

    $object->setUrlType(GroupMenuFunctions::URL_CATEGORY);
    if (isset($values['use_title']) && $values['use_title'] == 1) {
      $object->setUrlType(GroupMenuFunctions::URL_CATEGORY_TITLE);
    }

    if ($values['category_id'] == 0) {
      // Wybrano stworzenie nowego artykułu
      $categoryUniqueName = ArtConfiguration::getConfig('basic_category_example', 'basic-category-example');
      $categoryExample = Doctrine::getTable('Category')->getCategoryDataForCopy($categoryUniqueName);
      if ($categoryExample) {
        $category = new Category();
        // Nie mozemy uzyc $article->copy() bo niestety jest wyciek pamieci
        $category->copyFromArray($categoryExample);
        $category->setIsDisplayed(1);
        if (!is_null($this->getOption('category_id', null))) {
          $category->link('Categories', $this->getOption('category_id'));
        }
        $category->save();
      } else {
        throw new sfException('Brak kategorii o unique_name "' . $categoryUniqueName . '" do skopiowania.');
      }

      $values['category_id'] = $category->getId();
    } else {
      $category = Doctrine::getTable('Category')->findOneById($values['category_id']);
    }

    foreach ($this->getEmbeddedForms() as $form) {
      $form->getObject()->set('url', $values['category_id']);

      if ($object->getUrlType() == GroupMenuFunctions::URL_CATEGORY_TITLE) {
        $form->getObject()->set('title', $category->getName());
      }
    }

    return $object;
  }

}
