<?php

/**
 * PluginMenuItem form.
 *
 * @package    ##PROJECT_NAME##
 * @author     ##AUTHOR_NAME##
 */
abstract class PluginMenuItemLinkForm extends BaseMenuItemForm {

    public function configure() {
        $this->useFields(array('id'));

        if ($this->getObject()->getUrlType() == GroupMenuFunctions::URL_EMPTY) {
            $this->setWidget('info', new artWidgetFormShowText(
                    __('Pozycja nigdzie nie prowadzi. Jeśli chcesz, aby prowadziła do dowolnego adresu, uzupełnij poniżej pełny adres URL dla wszystkich języków.')
            ));
        } else {
            $this->setWidget('info', new artWidgetFormShowText(
                    __('Pozycja będzie prowadzić do podanego przez Ciebie pełnego adresu URL. Jeśli chcesz, aby pozycja nigdzie nie prowadziła, zostaw pole URL puste.')
            ));
        }
        $this->setValidator('info', new sfValidatorPass());

        $this->embedI18nWithLabels();

        foreach ($this->getFormFieldSchema() as $name => $field) {
            $this->getWidget($name)->setAttribute('class', 'form-control');
        }

        $this->disableRequiredsFieldText();
        $this->getWidgetSchema()->setFormFormatterName('flaty');
    }

    public function updateObject($values = null) {
        $object = parent::updateObject($values);

        $object->setUrlType(GroupMenuFunctions::URL_RAW);
        $isTitleEmpty = false;
        foreach ($this->getEmbeddedForms() as $form) {
            if ($form->getObject()->get('url') == '') {
                $object->setUrlType(GroupMenuFunctions::URL_EMPTY);
                $isTitleEmpty = true;
                break;
            }
        }

        if ($isTitleEmpty) {
            foreach ($this->getEmbeddedForms() as $form) {
                $form->getObject()->set('url', '');
            }
        }

        return $object;
    }

}
