<?php

/**
 * PluginMenuItem form.
 *
 * @package    ##PROJECT_NAME##
 * @author     ##AUTHOR_NAME##
 */
abstract class PluginMenuItemRoutingForm extends BaseMenuItemForm {

  public function configure() {
    $this->useFields(array('id'));

    $this->setWidget('info', new artWidgetFormShowText(
        __('Poniżej możesz wybrać moduł do którego będzie prowadzić dana pozycja.')
    ));
    $this->setValidator('info', new sfValidatorPass());

    $choices = $this->getRoutingChoices();
    
    $this->setWidget('routing', new sfWidgetFormChoice(
            array('multiple' => false, 'choices' => $choices)
//            , 
//            array('class' => 'chosen-select')
            ));
    
    $this->setValidator('routing', new sfValidatorChoice(array('multiple' => false, 'choices' => array_keys($choices))));
    $this->widgetSchema['routing']->setLabel(false);

    $this->embedI18nWithLabels();
    foreach ($this->getEmbeddedForms() as $name => $form) {
      unset($this->widgetSchema[$name]['url']);
    }

    $this->disableRequiredsFieldText();
    $this->getWidgetSchema()->setFormFormatterName('Bootstrap');
  }

  public function getRoutingChoices() {
    $routing = sfContext::getInstance()->getRouting();
    $routes = array();

    foreach ($routing->getRoutes() as $route_id => $route) {
      $options = $route->getOptions();
      
      if (isset($options['visible_in_fm']) && $options['visible_in_fm']) {
        $routes[$route_id] = $options['visible_in_fm'];
      }
    }
    
    return $routes;
  }

  public function updateObject($values = null) {
    $object = parent::updateObject($values);

    $object->setUrlType(GroupMenuFunctions::URL_ROUTING);
    foreach ($this->getEmbeddedForms() as $form) {
      $form->getObject()->set('url', $values['routing']);
    }

    return $object;
  }

}
