<?php

/**
 * Description of PluginArticleBaseForm
 * Formularz podstawowy
 */
class PluginArticleBaseForm extends BaseArticleForm
{
  public function setup()
  {
    $hasTitleImage = $this->object->hasTitleImageForForm();
    $hasBigImage = $this->object->hasBigImage();

    $this->setWidgets(array(
        'id' => new sfWidgetFormInputHidden(),
        'creator_id' => new sfWidgetFormInputHidden(),
        'editor_id' => new sfWidgetFormInputHidden(),
        'layout_id' => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('Layout'), 'add_empty' => false)),
        'is_displayed' => new sfArtWidgetFormLogic(),
        'start_at' => new sfArtWidgetFormInputJQueryDate(array('min_year' => date('Y'), 'max_year' => (date('Y') + 5))),
        'expire_at' => new sfArtWidgetFormInputJQueryDate(array('min_year' => date('Y'), 'max_year' => (date('Y') + 5))),
//      'flag' => new sfWidgetFormTextarea(),
        'title_image' => new sfArtWidgetFormInputFileEditable(array(
            'file_src' => $hasTitleImage ? Article::getTitleImagePath() . $this->getObject()->get('title_image') : false,
            'edit_mode' => true,
            'is_image' => true,
            'with_delete' => $hasTitleImage)),
        'title_image_label'       => new sfWidgetFormInputText(),
        'big_image' => new sfArtWidgetFormInputFileEditable(array(
            'file_src' => $hasBigImage ? Article::getBigImagePath() . $this->getObject()->get('big_image') : false,
            'edit_mode' => true,
            'is_image' => true,
            'with_delete' => $hasBigImage)),
        'source' => new sfWidgetFormInputText(),
//        'unique_name' => new sfWidgetFormInputText(),
        'categories_list' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('multiple' => true, 'model' => 'Category', 'table_method' => 'getTranslationList')),
        'tags_list' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('multiple' => true, 'model' => 'Tag', 'table_method' => 'getTranslationList')),
        'permissions_list' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('multiple' => true, 'model' => 'sfGuardPermission')),
        'groups_list' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('multiple' => true, 'model' => 'sfGuardGroup')),
        'preferred_articles_list' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('multiple' => true, 'model' => 'Article', 'table_method' => 'getArticlesWithoutOne')),
    ));

    $this->setValidators(array(
        'id' => new sfValidatorChoice(array('choices' => array($this->getObject()->get('id')), 'empty_value' => $this->getObject()->get('id'), 'required' => false)),
        'creator_id' => new sfValidatorPass(),
        'editor_id' => new sfValidatorPass(),
        'layout_id' => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('Layout'))),
        'is_displayed' => new sfArtValidatorFormLogic(),
        'start_at' => new sfValidatorDateTime(array('required' => false)),
        'expire_at' => new sfValidatorDateTime(array('required' => false)),
//      'flag'                    => new sfValidatorString(array('required' => false)),
        'title_image' => new sfArtValidatorFile(array(
            'path' => Article::getTitleImageAbsolutePath(),
            'max_size' => 4194304,
            'resize_size' => sfConfig::get('app_article_title_image_size', 150),
            'required' => false
        )),
        'title_image_label'       => new sfValidatorString(array('max_length' => 255, 'required' => false)),
        'title_image_delete' => new sfValidatorBoolean(),
        'big_image' => new sfArtValidatorFile(array(
            'path' => Article::getBigImageAbsolutePath(),
            'max_size' => 4194304,
            'resize_size' => sfConfig::get('app_article_big_image_size', 500),
            'required' => false
        )),
        'big_image_delete' => new sfValidatorBoolean(),
        'source' => new sfValidatorString(array('max_length' => 500, 'required' => false)),
//        'unique_name' => new sfValidatorString(array('max_length' => 100, 'required' => false)),
        'categories_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'Category', 'required' => false)),
        'tags_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'Tag', 'required' => false)),
        'permissions_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'sfGuardPermission', 'required' => false)),
        'groups_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'sfGuardGroup', 'required' => false)),
        'preferred_articles_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'Article', 'required' => false)),
    ));
    
//    if (ArticleSettings::hasGallery())
//      $this->widgetSchema->setHelp('unique_name', 'Edit only if not set and you want use gallery.');
    
    if ($this->isNew())
      unset($this['editor_id']);
    else
      unset($this['creator_id']);
    
    $this->embedI18nWithLabels();

    $this->widgetSchema->setNameFormat('article[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    $this->setupArticleSettings();
  }

  public function getTranslationLevelsArray()
  {
    return array(
        array('title', 'slug'),
        array('short_description'),
        array('description')
    );
  }
  
  public function getRightTranslationLevelsArray()
  {
    return array(
        array('meta_title'),
        array('meta_description'),
        array('meta_keywords')
    );
  }

  public function getLevelsArray()
  {
    return array(
        array('layout_id', 'is_displayed'),
        array('start_at', 'expire_at'),
        array('categories_list'), 
//        'unique_name' => array('unique_name'),
        array('title_image'), 
        array('title_image_label'), 
        'big_image' => array('big_image'),
        'source' => array('source'),
        'permissions_list' => array('permissions_list'), 
        'groups_list' => array('groups_list'),
        'tags_list' => array('tags_list'), 
        'preferred_articles_list' => array('preferred_articles_list')
    );
  }

  public function setupArticleSettings()
  {
    if (!ArticleSettings::hasBigImage())
    {
      unset($this->levels['big_image']);
      unset($this['big_image']);
      unset($this['big_image_delete']);
    }

    if (!ArticleSettings::hasSource())
    {
      unset($this->levels['source']);
      unset($this['source']);
    }

    if (!ArticleSettings::hasPermissionsAndGroups())
    {
      unset($this->levels['permissions_list']);
      unset($this->levels['groups_list']);
      unset($this['permissions_list']);
      unset($this['groups_list']);
    }

    if (!ArticleSettings::hasTags())
    {
      unset($this->levels['tags_list']);
      unset($this['tags_list']);
    }

    if (!ArticleSettings::hasSeeAlso())
    {
      unset($this->levels['preferred_articles_list']);
      unset($this['preferred_articles_list']);
    }
  }

  public function bind(array $taintedValues = null, array $taintedFiles = null)
  {
//    var_dump($taintedValues);
//    var_dump($taintedFiles);
    
    if (!is_null($taintedFiles) && !empty($taintedFiles))
    {
      $photoName = $taintedValues['id'] . '_' . Slug::slugify($taintedValues['pl']['title']);
      $this->validatorSchema['title_image']->setNewName($photoName);
      
      if (ArticleSettings::hasBigImage())
        $this->validatorSchema['big_image']->setNewName($photoName);
    }

    if ($taintedValues['start_at'] != '' || $taintedValues['expire_at'] != '')
    {
      $this->validatorSchema['start_at'] = new sfValidatorDateTime();
      $this->validatorSchema['expire_at'] = new sfValidatorDateTime();
    }

    parent::bind($taintedValues, $taintedFiles);
  }

  public function save($con = null)
  {
    artTask::clearCache();

    if ($this->isNew())
      $this->values['creator_id'] = BaseForm::getUserId();
    else
      $this->values['editor_id'] = BaseForm::getUserId();

    $this->values['created_at'] = artDate::today();
    $this->values['updated_at'] = artDate::today();

    if (isset($this->values['start_at']))
      $this->values['start_at'] = date('Y-m-d', strtotime($this->values['start_at'])) . ' 00:00:00';
    else
      unset($this->values['start_at']);
    if (isset($this->values['expire_at']))
      $this->values['expire_at'] = date('Y-m-d', strtotime($this->values['start_at'])) . ' 23:59:59';
    else
      unset($this->values['expire_at']);

    return parent::save($con);
  }
  
  public function saveCategoriesList($con = null)
  {
    if (!$this->isValid())
      throw $this->getErrorSchema();

    if (!isset($this->widgetSchema['categories_list']))
      return;

    if (null === $con)
      $con = $this->getConnection();

    $existing = $this->object->getArticleCategories()->getPrimaryKeys();
    $values = $this->getValue('categories_list');
    
    if (!$this->validatorSchema['categories_list']->getOption('multiple', true))
      $values = (array)$values;
    else if (!is_array($values))
      $values = array();

    $unlink = array_diff($existing, $values);
    
    if (count($unlink))
    {
      $this->object->unlink('Categories', array_values($unlink));
      Article::deleteCategoriesList($unlink);
    }

    $link = array_diff($values, $existing);
    
    if (count($link))
      $this->object->link('Categories', array_values($link));
  }
  
}

