<?php

/**
 * PluginArticleComment form.
 *
 * @package    ##PROJECT_NAME##
 * @author     ##AUTHOR_NAME##
 */
abstract class PluginArticleCommentForm extends BaseArticleCommentForm
{

  public function setup()
  {
    parent::setup();

    $this->setWidgets(array(   
      'article_id'                => new sfWidgetFormInputHidden(),
      'user_id'                => new sfWidgetFormInputHidden(),
      'nick'                      => new sfWidgetFormInputText(),  
      'text'                      => new sfWidgetFormTextarea(),   
        
    ));
 
    $this->setValidators(array(
      'article_id'                => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('Article'))),
      'user_id' => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('sfGuardUser'), 'required' => false)),
      'text'                      => new sfValidatorString(array('max_length' => 100, 'required' => true, 'trim'=>true)),
      'nick'                      => new sfValidatorString(array('max_length' => 100, 'required' => true, 'trim'=>true)),
      
    ));

    $this->widgetSchema->setNameFormat('article_comment[%s]');
    
    $this->setDefault('article_id', $this->getRequest()->getParameter('id'));
    $this->setDefault('nick',$this->getRequest()->getCookie('article_comment_nick', ''));
    
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    $this->setupInheritance();

  }
  
          
  public function save($con = null)
  {
    //$this->values['article_id'] = $this->getRequest()->getParameter('id');
    
    if (isset($this->values['nick']))
      sfContext::getInstance()->getResponse()->setCookie('article_comment_nick', $this->values['nick'] , time() + 52*7*24*3600, '/');
    
    if ($this->getUser()->isAuthenticated())
      $this->values['user_id'] = $this->getUserId();
    else 
      $this->values['user_id'] = 2;
    
    return parent::save($con);
  }
  
}
