<?php

/**
 * PluginArticle form.
 *
 * @package    ##PROJECT_NAME##
 * @subpackage form
 * @author     ##AUTHOR_NAME##
 * @version    SVN: $Id: sfDoctrineFormPluginTemplate.php 23810 2009-11-12 11:07:44Z Kris.Wallsmith $
 */
abstract class PluginArticleForm extends BaseArticleForm {

  public function configure() {
    $this->setWidgets(array(
        'id' => new sfWidgetFormInputHidden(),
        'created_at' => new sfArtWidgetFormInputJQueryDateTime(),
        'source' => new sfWidgetFormInput(array(), array()),
        'layout_id' => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('Layout'), 'add_empty' => false)),
        'start_at' => new flatyWidgetFormInputDate(array('label' => 'Data wydarzenia'), array('class' => 'date-picker')),
        'expire_at' => new sfArtWidgetFormInputJQueryDateTime(),
        'flag' => new sfArtWidgetFormTextarea(),
        'title_image' => new sfArtWidgetFormInputAjaxFileEditable(array(
            'file_src' => $this->getObject()->getTitleImageSrc(),
            'edit_mode' => true,
            'is_image' => true,
            'with_delete' => false,
                )),
        'big_image' => new sfArtWidgetFormInputAjaxFileEditable(array(
            'file_src' => $this->getObject()->getBigImageSrc(),
            'edit_mode' => true,
            'is_image' => true,
            'with_delete' => false,
                )),
        'source' => new sfWidgetFormInputText(array('label' => 'Film Vimeo / Youtube')),
        'tags_list' => new sfWidgetFormDoctrineChoice(
                array('multiple' => true, 'model' => 'Tag')
                , array('class' => 'chosen-select', 'data-placeholder' => 'Wybierz tagi...')),
        'categories_list' => new sfWidgetFormDoctrineChoice(
                array('multiple' => false, 'model' => $this->getRelatedModelName('Categories'), 'add_empty' => true)
                , array('class' => 'chosen-select', 'data-placeholder' => 'Wybierz kategorię...')),
    ));

    $this->setValidators(array(
        'id' => new sfValidatorChoice(array('choices' => array($this->getObject()->get('id')), 'empty_value' => $this->getObject()->get('id'), 'required' => false)),
        'created_at' => new sfValidatorDateTime(),
        'expire_at' => new sfValidatorDateTime(array('required' => false)),
        'source' => new sfValidatorString(array('required' => false)),
        'layout_id' => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('Layout'))),
        'start_at' => new sfValidatorDate(array('required' => false)),
        'expire_at' => new sfValidatorDateTime(array('required' => false)),
        'flag' => new sfValidatorString(array('required' => false)),
        'title_image' => new sfArtValidatorFile(array(
            'path' => Article::getTitleImageAbsolutePath(),
            'max_size' => sfConfig::get('app_art_cms_plugin_article_title_image_max_size', 512000),
            'resize_size_width' => $this->getObject()->getParam('title_image_width', sfConfig::get('app_art_cms_plugin_article_title_image_width', ArtConfiguration::getArtCmsArticleTitleImageWidth())),
            'resize_size_height' => $this->getObject()->getParam('title_image_height', sfConfig::get('app_art_cms_plugin_article_title_image_height', ArtConfiguration::getArtCmsArticleTitleImageHeight())),
            'required' => false
                )),
        'big_image' => new sfArtValidatorFile(array(
            'path' => Article::getBigImageAbsolutePath(),
            'max_size' => sfConfig::get('app_art_cms_plugin_article_big_image_max_size', 4194304),
            'resize_size_width' => $this->getObject()->getParam('big_image_width', sfConfig::get('app_art_cms_plugin_article_big_image_width', 370)),
            'resize_size_height' => $this->getObject()->getParam('big_image_height', sfConfig::get('app_art_cms_plugin_article_big_image_height', 288)),
            'required' => false
                )),
        'source' => new sfValidatorString(array('max_length' => 500, 'required' => false)),
        'tags_list' => new sfValidatorDoctrineChoice(array('multiple' => false, 'model' => 'Tag', 'required' => false)),
        'categories_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => $this->getRelatedModelName('Categories'), 'required' => false)),
    ));

    $this->initFields();
    if ($this->getOption('task') != 'add') {
      $this->embedI18nWithLabels();
    }

    foreach ($this->getFormFieldSchema() as $name => $field) {
      $this->getWidget($name)->setAttribute('class', $this->getWidget($name)->getAttribute('class').' form-control');
    }

    $this->disableRequiredsFieldText();
    $this->getWidgetSchema()->setFormFormatterName('Flaty');

    $this->widgetSchema->setNameFormat('article[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function getPartial() {
    if ($this->getOption('task') == 'add') {
      return 'frontendManagement/confirmPopup';
    } else {
      return false;
    }
  }

  public function initObject() {
//    $object = parent::updateObject($values);
    $userId = sfContext::getInstance()->getUser()->getId();
    $options = $this->getOptions();

    if ($options['task'] == 'add') {
      if (isset($options['article_example']) && $options['article_example'] != '') {
        $articleUniqueName = $options['article_example'];
      } else {
        $articleUniqueName = ArtConfiguration::getConfig('basic_article_example', 'basic-article-example');
      }

      $articleExample = Doctrine::getTable('Article')->getArticleDataForCopy($articleUniqueName);
      if ($articleExample) {
        // Nie mozemy uzyc $article->copy() bo niestety jest wyciek pamieci
        $this->getObject()->copyFromArray($articleExample);
        $this->getObject()->setCreatorId($userId);
        $this->getObject()->setEditorId($userId);
        $this->getObject()->setUniqueName(NULL);
        $this->getObject()->setIsDisplayed(1);
      } else {
        throw new sfException('Brak artykulu o unique_name "' . $articleUniqueName . '" do skopiowania.');
      }

      if (isset($options['category_id'])) {
        // Przypisujemy kategorie do artykulu
        $this->getObject()->link('Categories', $options['category_id']);
      }

      $this->getObject()->setCreatorId($userId);
    }

    $this->getObject()->setEditorId($userId);
  }

  /**
   * Funkcja nadpisana aby pole updated_at bylo rowniez aktualizowane jesli
   * zmieniamy pola z tabel translacyjnych. Ustawia order w przypadku nowego obiektu
   * 
   * @param type $con 
   */
  public function save($con = null) {
    if ($this->getOption('task') == 'add') {
      // Przy dodawaniu robimy kopiowanie wiec calkowicie inaczej to obslugujemy
      $this->initObject();
      $this->getObject()->save();
    } else {
      $this->updateObject();
      $updated = false;

      // Sprawdzamy czy obiekt zostal zmieniony
      if (!$this->getObject()->isModified()) {
        // Sprawdzamy czy ktorykolwiek obiekt w embeddedForms zostal zmieniony
        foreach ($this->getEmbeddedForms() as $embeddedForm) {
          if ($embeddedForm->getObject()->isModified()) {
            $updated = true;
            break;
          }
        }
      }

      if ($updated) {
        $this->getObject()->setUpdatedAt(artDate::today());
      }

      $isNew = $this->getObject()->isNew();
      parent::save($con);

      if ($isNew) {
        // Ustawiamy order po zapisie obiektu
        $articleCategories = $this->getObject()->getArticleCategories();
        if ($articleCategories->count() > 0) {
          foreach ($articleCategories as $articleCategory) {
            $order = 1 + Doctrine::getTable('ArticleCategory')->getMaxOrder($articleCategory->getCategoryId());
            $articleCategory->setOrder($order);
            $articleCategory->save();
            $order++;
          }
        }
      }
    }
  }

  protected function useTranslationFields() {
    $fields = array('id', 'lang');
    $object = $this->getObject();

    if ($this->getOption('task') == 'edit') {
      if ($object->hasDescription()) {
        $fields[] = 'description';
      }
      if ($object->hasShortDescription()) {
        $fields[] = 'short_description';
      }
      if ($object->hasTitle()) {
        $fields[] = 'title';
      }
    }

    return $fields;
  }

  protected function initFields() {
    $fields = array('id');
    $object = $this->getObject();

    if ($this->getOption('task') == 'edit') {
      if ($object->hasLayoutTitleImage()) {
        $fields[] = 'title_image';
      }

      if ($object->hasLayoutBigImage()) {
        $fields[] = 'big_image';
      }

      if ($object->hasVideo()) {
        $fields[] = 'source';
      }

      if ($object->hasLayoutTags()) {
        $fields[] = 'tags_list';
      }
      
      if ($object->hasLayoutCategories()) {
        $fields[] = 'categories_list';
      }
      
      if ($object->hasStartAt()) {
        $fields[] = 'start_at';
      }

      if ($object->hasParam('title_image_label')) {
        $fields[] = 'title_image_label';
      }
    }
    
    $this->useFields($fields);
  }

  public function getIcon() {
    if ($this->getOption('task') == 'delete') {
      return 'megaicon1-document-sans-remove';
    }
    if ($this->getOption('task') == 'add') {
      return 'megaicon1-document-sans-add';
    }
    if ($this->getOption('task') == 'edit') {
      return 'megaicon1-document-sans-edit';
    }
  }

}
