<?php

/**
 * PluginArticlePhoto form.
 *
 * @package    ##PROJECT_NAME##
 * @subpackage form
 * @author     ##AUTHOR_NAME##
 * @version    SVN: $Id: sfDoctrineFormPluginTemplate.php 23810 2009-11-12 11:07:44Z Kris.Wallsmith $
 */
abstract class PluginArticlePhotoForm extends BaseArticlePhotoForm {

    public function setup() {
        parent::setup();

        if ($this->getObject()->isNew() && $this->getOption('task') == 'add') {
            $this->getObject()->setArticleId($this->getOption('article_id'));
        }

        $this->setWidget('original_image', new sfArtWidgetFormInputAjaxFileEditable(array(
            'file_src' => $this->getObject()->getImagePath('small'),
            'edit_mode' => true,
            'is_image' => true,
            'with_delete' => false,
                ))
        );

        $this->setValidator('original_image', new sfArtValidatorFile(array(
            'path' => $this->getObject()->getImageAbsoluteDir('original'),
            'max_size' => sfConfig::get('app_art_cms_plugin_management_photo_max_size', 4096000),
            'required' => ($this->getObject()->isNew() ? true : false),
                ))
        );
        foreach ($this->getFormFieldSchema() as $name => $field) {
            $this->getWidget($name)->setAttribute('class', 'form-control');
        }

        $this->useFields(array('id', 'original_image'));
        $this->embedI18nWithLabels();

        $this->disableRequiredsFieldText();
        $this->getWidgetSchema()->setFormFormatterName('Flaty');

        $this->widgetSchema->setNameFormat('article_photo[%s]');
        $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
        $this->setupInheritance();
    }

    protected function useTranslationFields() {
        return array('id', 'title', 'lang');
    }

    /**
     * Funkcja nadpisana aby pole updated_at bylo rowniez aktualizowane jesli
     * zmieniamy pola z tabel translacyjnych.
     * Funkcja automatyczne robi resize zdjęć
     * 
     * @param type $con 
     */
    public function save($con = null) {
        $this->updateObject();

        $article = $this->getObject()->getArticle();

        // Jesli original_image nie jest pusty
        if (isset($this->values['original_image']) && !is_null($this->values['original_image'])) {

            foreach (GalleryManagement::getPhotoSizes($article) as $size => $options) {

                if (isset($options['extension'])) {
                    $extension = $options['extension'];
                } else {
                    $extension = $this->values['original_image']->getOriginalExtension();
                }

                $fileName = artPhotoConverter::generateFileName('article_photo', $extension);

                try {
                    artPhotoConverter::resizePhoto(
                            $options, $this->values['original_image']->getSavedName(), $this->getObject()->getImageAbsoluteDir($size) . $fileName
                    );
                } catch (Exception $e) {
                    throw new sfException('Sprawdź czy masz zainstalowane pakiety: imagemagick oraz php5-imagick: error:' . $e);
                }

                $this->getObject()->set($size . '_image', $fileName);
            }
        }

        $updated = false;
        // Sprawdzamy czy obiekt zostal zmieniony
        if (!$this->getObject()->isModified()) {
            // Sprawdzamy czy ktorykolwiek obiekt w embeddedForms zostal zmieniony
            foreach ($this->getEmbeddedForms() as $embeddedForm) {
                if ($embeddedForm->getObject()->isModified()) {
                    $updated = true;
                    break;
                }
            }
        }

        if ($updated) {
            $this->getObject()->setUpdatedAt(artDate::today());
        }

        return parent::save($con);
    }

}
