<?php

/**
 * PluginCategory form.
 *
 * @package    ##PROJECT_NAME##
 * @subpackage form
 * @author     ##AUTHOR_NAME##
 * @version    SVN: $Id: sfDoctrineFormPluginTemplate.php 23810 2009-11-12 11:07:44Z Kris.Wallsmith $
 */
abstract class PluginCategoryForm extends BaseCategoryForm {

    public function configure() {
        $hasTitleImage = $this->object->hasTitleImage();
        $this->setWidget('title_image', new sfArtWidgetFormInputAjaxFileEditable(array(
            'file_src' => $hasTitleImage ? Category::getTitleImagePath() . $this->getObject()->get('title_image') : false,
            'edit_mode' => true,
            'is_image' => true,
            'with_delete' => $hasTitleImage)));
        $this->setValidator('title_image', new sfArtValidatorFile(array(
            'path' => Category::getTitleImageAbsolutePath(),
            'max_size' => 4194304,
            'resize_size' => sfConfig::get('app_art_cms_plugin_category_title_image_size', 600),
            'required' => false
        )));
        
        $this->setWidget('category_list', new sfWidgetFormDoctrineChoice(
                array('multiple' => false, 'model' => $this->getRelatedModelName('Category'), 'add_empty' => true)
                , array('class' => 'chosen-select', 'data-placeholder' => 'Wybierz kategorię...')));
        $this->setValidator('category_list', new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => $this->getRelatedModelName('Category'), 'required' => false)));


        $this->initFields();
        $this->embedI18nWithLabels();
        $this->disableRequiredsFieldText();

        foreach ($this->getFormFieldSchema() as $name => $field) {
            $this->getWidget($name)->setAttribute('class', 'form-control');
        }
        $this->getWidgetSchema()->setFormFormatterName('Flaty');
        $this->widgetSchema->setNameFormat('article[%s]');
        $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
        $this->setupInheritance();
    }

    public function useTranslationFields() {
        $fields = array('id', 'name', 'lang');

        if ($this->getObject()->hasDescription()) {
            $fields[] = 'description';
        }

        return $fields;
    }

    public function initFields() {
        $array = array('id', 'category_list');
        $this->useFields($array);
    }

    public function saveSubcategoriesList($con = null) {
        return;
    }

    public function getIcon() {
        if ($this->getOption('task') == 'delete') {
            return 'megaicon1-document-sans-remove';
        }
        if ($this->getOption('task') == 'add') {
            return 'megaicon1-document-sans-add';
        }
        if ($this->getOption('task') == 'edit') {
            return 'megaicon1-document-sans-edit';
        }
    }

}
