<?php

/**
 * PluginMenuGroup form.
 *
 * @package    ##PROJECT_NAME##
 * @author     ##AUTHOR_NAME##
 */
abstract class PluginMenuGroupForm extends BaseMenuGroupForm
{

  public function configure()
  {
    if ($this->getOption('task') == 'add') {
      $this->setWidget('info', new artWidgetFormShowText(
            __('Uzupełnij nazwę tworzonego submenu.')
        ));
    } else {
      $this->setWidget('info', new artWidgetFormShowText(
            __('Uzupełnij nazwę menu.')
        ));
    }
    
    $this->setValidator('info', new sfValidatorPass());
    
    $this->getWidgetSchema()->moveField('info', sfWidgetFormSchema::FIRST);
    
    unset($this['updated_at'], $this['created_at']);
    if (!sfContext::getInstance()->getUser()->isArteneo()) {
     unset($this['unique_name']); 
    }
    
        foreach ($this->getFormFieldSchema() as $name => $field) {
      $this->getWidget($name)->setAttribute('class', 'form-control');
    }
    
    $this->disableRequiredsFieldText();
    $this->getWidgetSchema()->setFormFormatterName('Flaty');
  }
  
  public function save($con = null) {
      
            
    if ($this->isNew())
      $this->getObject()->setUniqueName(Slug::slugify($this->getObject()->getName())); 
   
    parent::save($con);    
    
    if ($this->getOption('task') == 'add' && $this->getOption('menu_item_id', false)) {
      $menuItem = Doctrine::getTable('MenuItem')->findOneById($this->getOption('menu_item_id'));
      $menuItem->setSubmenuId($this->getObject()->getId());
      $menuItem->save();
    }
  }
      public function getIcon() {
        if ($this->getOption('task') == 'delete') {
            return 'megaicon1-trash';
        }
        if ($this->getOption('task') == 'add') {
            return 'megaicon1-plus';
        }
        if ($this->getOption('task') == 'edit') {
            return 'megaicon1-pencil';
        }
    }
}
