<?php

/**
 * PluginMenuItem form.
 *
 * @package    ##PROJECT_NAME##
 * @author     ##AUTHOR_NAME##
 */
abstract class PluginMenuItemForm extends BaseMenuItemForm {

  public function configure() {
    $this->useFields(array('id'));
    if ($this->getOption('task') == 'add') {
      $this->getObject()->setMenuId($this->getOption('menu_group_id'));
    }

    if (!sfContext::getInstance()->getUser()->isArteneo()) {
      unset($this['json']);
      $this->setWidget('menu_id_info', new artWidgetFormShowText(
              __('Pozycja jest przypisana do menu o nazwie "%name%".', array('%name%' => $this->getObject()->getMenu()->getName()))
      ));
      $this->setValidator('menu_id_info', new sfValidatorPass());
      if ($this->getObject()->getSubmenuId()) {
        $this->setWidget('submenu_id_info', new artWidgetFormShowText(
                __('Pozycja jest posiada do menu rozwijane o nazwie "%name%".', array('%name%' => $this->getObject()->getSubmenu()->getName()))
        ));
      } else {
        $this->setWidget('submenu_id_info', new artWidgetFormShowText(
                __('Pozycja nie posiada submenu')
        ));
      }

      $this->setValidator('submenu_id_info', new sfValidatorPass());
    } else {
      $this->setWidget('menu_id', new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('Menu'), 'add_empty' => false)));
      $this->setWidget('submenu_id', new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('Submenu'), 'add_empty' => true)));
    }

    $this->disableRequiredsFieldText();

    $this->embedForm('article', new MenuItemArticleForm($this->getObject(), $this->getOptions()));
    $this->embedForm('category', new MenuItemCategoryForm($this->getObject(), $this->getOptions()));

    $routingForm = new MenuItemRoutingForm($this->getObject(), $this->getOptions());
    if (count($routingForm->getRoutingChoices()) > 0) {
      $this->embedForm('routing', $routingForm);
      $this->getWidgetSchema()->setLabel('routing', 'Moduł');
    }
    $this->embedForm('link_raw', new MenuItemLinkForm($this->getObject(), $this->getOptions()));
    $this->getWidgetSchema()->setLabel('article', 'Artykuł');
    $this->getWidgetSchema()->setLabel('category', 'Lista artykułów');
    $this->getWidgetSchema()->setLabel('link_raw', 'Link');

    $this->setWidget('active_tab', new sfWidgetFormInputHidden(array('default' => $this->getActiveTab())));
    $this->setValidator('active_tab', new sfValidatorChoice(array('multiple' => false, 'choices' => array_keys($this->getEmbeddedForms()))));

    foreach ($this->getFormFieldSchema() as $name => $field) {
      $this->getWidget($name)->setAttribute('class', 'form-control');
    }

    $this->disableRequiredsFieldText();
    $this->getWidgetSchema()->setFormFormatterName('Flaty');
    //$this->getWidgetSchema()->getFormFormatter()->setEmbeddedIcons(true);
  }

  public function getActiveTab() {
    $urlType = $this->getObject()->getUrlType();
    if (isset($this['article']) &&
            ( $urlType == GroupMenuFunctions::URL_ARTICLE || $urlType == GroupMenuFunctions::URL_ARTICLE_TITLE)) {
      return 'article';
    }

    if (isset($this['category']) &&
            ( $urlType == GroupMenuFunctions::URL_CATEGORY || $urlType == GroupMenuFunctions::URL_CATEGORY_TITLE)) {
      return 'category';
    }

    if (isset($this['routing']) &&
            ( $urlType == GroupMenuFunctions::URL_ROUTING )) {
      return 'routing';
    }

    if (isset($this['link_raw']) &&
            ( $urlType == GroupMenuFunctions::URL_RAW || $urlType == GroupMenuFunctions::URL_EMPTY)) {
      return 'link_raw';
    }

    return 'article';
  }

  public function getPartial() {
    $task = $this->getOption('task');
    if ($task == 'add' || $task == 'edit') {
      return 'frontendManagement/menuItemForm' . ucfirst($this->getOption('task'));
    } else {
      return false;
    }
  }

  protected function doUpdateObject($values) {
    parent::doUpdateObject($values);

    if ($this->getObject()->isNew()) {
      // Dla nowych MenuItem ustawiamy order na ostatni w MenuGroup
      $newOrder = Doctrine::getTable('MenuItem')->getMaxOrder($this->getObject()->getMenuId());
      $newOrder++;
      $this->getObject()->setOrder($newOrder);
    }
  }

  public function save($con = null) {
    // Co bysmy nie popsuli symfonii, klamiemy ja ze jest tylko jeden embedded form :)
    $embeddedForms = $this->embeddedForms;
    foreach ($embeddedForms as $name => $form) {
      if ($name != $this->getValue('active_tab')) {
        unset($this->embeddedForms[$name]);
      }
    }
    parent::save($con);
  }

  public function bind(array $taintedValues = null, array $taintedFiles = null) {
    $activeTab = $taintedValues['active_tab'];
    $task = $this->getOption('task');
    if ($task == 'add' || $task == 'edit') {
      if ($activeTab == 'article' || $activeTab == 'category') {
        if (!(isset($taintedValues[$activeTab]['use_title']) && $taintedValues[$activeTab]['use_title'] == 1)) {
          foreach ($this->getPreferredCulture() as $culture) {
            // Tytuł pozycji musi być obowiązkowy jeśli zaznaczyliśmy, że nie chcemy pobierać z artykułu / kategorii
            $this->validatorSchema[$activeTab][$culture]['title']->setOption('required', true);
          }
          // Odznaczamy checked="checked" na uzywaniu tytulu
          $attributes = $this->widgetSchema[$activeTab]['use_title']->getAttributes();
          unset($attributes['checked']);
          $this->widgetSchema[$activeTab]['use_title']->setAttributes($attributes);
        }
      }
    }

    parent::bind($taintedValues, $taintedFiles);
  }
      public function getIcon() {
        if ($this->getOption('task') == 'delete') {
            return 'megaicon1-trash-1';
        }
        if ($this->getOption('task') == 'add') {
            return 'megaicon1-plus';
        }
        if ($this->getOption('task') == 'edit') {
            return 'megaicon1-pencil';
        }
    }
}
