<?php

/**
 * PluginTag form.
 *
 * @package    ##PROJECT_NAME##
 * @subpackage form
 * @author     ##AUTHOR_NAME##
 * @version    SVN: $Id: sfDoctrineFormPluginTemplate.php 23810 2009-11-12 11:07:44Z Kris.Wallsmith $
 */
abstract class PluginTagForm extends BaseTagForm
{

  public function setup()
  {
    $this->setWidgets(array(
        'id' => new sfWidgetFormInputHidden(),
        'articles_list' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('multiple' => true, 'model' => 'Article')),
    ));

    $this->setValidators(array(
        'id' => new sfValidatorChoice(array('choices' => array($this->getObject()->get('id')), 'empty_value' => $this->getObject()->get('id'), 'required' => false)),
        'articles_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'Article', 'required' => false)),
    ));

    $this->widgetSchema->setNameFormat('tag[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
    $this->embedI18nWithLabels();
  }

  public function updateDefaultsFromObject()
  {
    parent::updateDefaultsFromObject();

    $articleId = $this->getRequest()->getParameter('article_id', false);

    if ($articleId)
      $this->setDefault('articles_list', $articleId);
  }

}
