<?php

/**
 * Formularz backendowy zmiany artykułu
 * @subpackage artCmsPlugin

 */
class PluginFlatyArticleForm extends BaseArticleForm {

  public function configure() {
    $this->useFields(array('id', 'unique_name', 'is_displayed', 'layout_id'));

    foreach ($this->getPreferredCulture() as $culture) {
      $this->embedForm($culture, new FlatyArticleTranslationForm($this->getObject()->Translation[$culture]));
    }

    $this->widgetSchema->setLabel('unique_name', 'Nazwa unikalna');
    $this->widgetSchema->setLabels($this->getCultureLabels());

    foreach ($this->getFormFieldSchema() as $name => $field) {
      $this->getWidget($name)->setAttribute('class', 'form-control');
    }

    $this->disableRequiredsFieldText();
    $this->getWidgetSchema()->setFormFormatterName('Flaty');
  }

  public function save($con = null) {
    $user = sfContext::getInstance()->getUser();
    $this->updateObject();
    $updated = false;

    // Sprawdzamy czy obiekt zostal zmieniony
    if (!$this->getObject()->isModified()) {
      // Sprawdzamy czy ktorykolwiek obiekt w embeddedForms zostal zmieniony
      foreach ($this->getEmbeddedForms() as $embeddedForm) {
        if ($embeddedForm->getObject()->isModified()) {
          $updated = true;
          break;
        }
      }
    }

    if ($updated) {
      $this->getObject()->setUpdatedAt(artDate::today());
      $this->getObject()->setEditorId($user->getId());
    } else {
      $this->getObject()->setCreatorId($user->getId());
    }

    return parent::save($con);
  }

}
