<?php

/**
 * Formularz backendowy zmiany kategori
 * @subpackage artCmsPlugin

 */
class PluginFlatyCategoryForm extends BaseCategoryForm {

  public function configure() {
    $this->useFields(array('id', 'unique_name', 'is_displayed', 'layout_id'));

    foreach ($this->getPreferredCulture() as $culture) {
      $this->embedForm($culture, new FlatyCategoryTranslationForm($this->getObject()->Translation[$culture]));
    }

    $this->widgetSchema->setLabel('unique_name', 'Nazwa unikalna');
    $this->widgetSchema->setLabels($this->getCultureLabels());

    foreach ($this->getFormFieldSchema() as $name => $field) {
      $this->getWidget($name)->setAttribute('class', 'form-control');
    }

    $this->disableRequiredsFieldText();
    $this->getWidgetSchema()->setFormFormatterName('Flaty');
  }
}
