<?php

/**
 * Formularz backendowy zmiany artykułu
 * @subpackage artCmsPlugin

 */
class PluginFlatyMenuItemForm extends BaseMenuItemForm {

  public function configure() {
    $this->useFields(array('id', 'menu_id', 'submenu_id', 'url_type', 'order', 'json'));

    $this->setWidget('json', new sfWidgetFormInputText());
    $this->setWidget('url_type', new sfWidgetFormChoice(array('choices' => BackendGroupMenu::getUrlTypes())));
    $this->setValidator('url_type', new sfValidatorChoice(array('choices' => array_keys(BackendGroupMenu::getUrlTypes()))));
    
    foreach ($this->getPreferredCulture() as $culture) {
      $this->embedForm($culture, new FlatyMenuItemTranslationForm($this->getObject()->Translation[$culture]));
    }

    $this->widgetSchema->setLabels($this->getCultureLabels());

    foreach ($this->getFormFieldSchema() as $name => $field) {
      $this->getWidget($name)->setAttribute('class', 'form-control');
    }

    $this->disableRequiredsFieldText();
    $this->getWidgetSchema()->setFormFormatterName('Flaty');
  }

  public function save($con = null) {
    $this->updateObject();
    $updated = false;

    // Sprawdzamy czy obiekt zostal zmieniony
    if (!$this->getObject()->isModified()) {
      // Sprawdzamy czy ktorykolwiek obiekt w embeddedForms zostal zmieniony
      foreach ($this->getEmbeddedForms() as $embeddedForm) {
        if ($embeddedForm->getObject()->isModified()) {
          $updated = true;
          break;
        }
      }
    }

    if ($updated) {
      $this->getObject()->setUpdatedAt(artDate::today());
    }

    return parent::save($con);
  }

}
