<?php
/**
 * Description of BaseMenu
 *

 */
abstract class BaseGroupMenu extends GroupMenuFunctions {
  protected $uniqueName = null;
  protected $culture = null;
  protected $settings = array();
  
  public function __construct($uniqueName, $settings) {
    $this->uniqueName = $uniqueName;
    $this->initSettings($settings);
    $this->culture = sfContext::getInstance()->getUser()->getCulture();
  }
  
  /**
   * Funkcja inicjuje ustawienia. Wykorzystuje getDefaultSettings() i tablice
   * parametrow $settings
   * 
   * @param array $settings
   */
  protected function initSettings($settings) {
    $this->settings = artArray::array_merge_recursive_replace($this->getDefaultSettings(), $settings);
  }
 
  /**
   * Funkcja zwraca wartosci default dla settings
   * @return array
   */
  public function getDefaultSettings()
  {
    return array(
        'options' => array(
            'data_collector' => 'GroupMenuDataCollector',
            'action_bar' => 'GroupMenuActionBar',
            'generator' => 'GroupMenuGenerator',
            'cache' => 'GroupMenuCache',
        ),
        'data_collector' => array(),
        'generator' => array(),
        'action_bar' => array(),
        'cache' => array(),
      );
  }
  
  /**
   * Funkcja odpowiada za zwrocenie HTML menu. Korzysta z klas ustawionych w 
   * settings.
   * 
   * @return string
   */
  public function generateMenu() {
    $settings = $this->settings;
    
    $dataCollectorClass = $settings['options']['data_collector'];
    $actionBarClass = $settings['options']['action_bar'];
    $generatorClass = $settings['options']['generator'];
    $cacheClass = $settings['options']['cache'];
    
    $cache = new $cacheClass($settings['cache'], $this->uniqueName, $this->culture);
    if (!$cache->isContentCached()) {
      $dataCollector = new $dataCollectorClass($this->uniqueName, $settings['data_collector'], $this->culture);
      $actionBar = new $actionBarClass($settings['action_bar'], $this->culture);
      $generator = new $generatorClass($settings['generator'], $dataCollector, $actionBar, $this->culture);
      
      $content = $generator->generateMenu();
      $cache->setContent($content);
    }
    
    $content = $cache->getContent();
    return $content;
  }
  
  /**
   * Zwraca zainicjowana klase dataCollectora
   * Uzywane np. w artSitemapTask
   * @return \dataCollector 
   */
  public function getDataCollector() {
    $settings = sfYaml::load( $this->filePath );
    $settings = $this->initSettings($settings);
    
    $dataCollectorClass = $settings['options']['data_collector'];
    
    return new $dataCollectorClass($settings['options']['category'], $settings['data_collector'], $this->culture);
  }
  
  /**
   * Zwraca zainicjowana klase generatora
   * Uzywane np. w artSitemapTask
   * @return \generator 
   */
  public function getGenerator($dataCollector) {
    $settings = sfYaml::load( $this->filePath );
    $settings = $this->initSettings($settings);
    
    $generatorClass = $settings['options']['generator'];
    $actionBarClass = $settings['options']['action_bar'];
    $actionBar = new $actionBarClass($settings['action_bar'], $dataCollectorClass);
    
    return new $generatorClass($settings['generator'], $dataCollector, $actionBar);
  }
  
  public static function getMenu($uniqueName, $settings = array()) {
    $className = get_called_class();
    
    $menuGenerator = new $className($uniqueName, $settings);
    return $menuGenerator->generateMenu();
  }
  
  /**
   * Funkcja odpowiada za zwrocenie URL dla elementu na danej pozycji.
   * 
   * @return string
   */
  public function generateHomepageUrl($position) {
    $settings = sfYaml::load( $this->filePath );
    $settings = $this->initSettings($settings);
    
    $dataCollectorClass = $settings['options']['data_collector'];
    $generatorClass = $settings['options']['generator'];
    // Wiecej niz 1 glebokosci nam nie potrzeba
    $settings['data_collector']['depth'] = 1;

    $dataCollector = new $dataCollectorClass($settings['options']['category'], $settings['data_collector'], $this->culture);
    $generator = new $generatorClass($settings['generator'], $dataCollector, null);

    return $generator->getHomepageUrl($position);
  }
  
  public static function getHomepageUrl($fileName, $position) {
    $className = get_called_class();
    
    $menuGenerator = new $className($fileName);
    return $menuGenerator->generateHomepageUrl($position);
  }
  
}

