<?php

/**
 * Description of BaseGroupMenuFunctions
 *

 */
abstract class BaseGroupMenuFunctions {

  /**
   * Pozycja prowadzaca do Artykulu o ID umieszczonym w polu URL
   */
  const URL_ARTICLE = 0;

  /**
   * Pozycja prowadzaca do Artykulu o ID umieszczonym w polu URL.
   * Pobierana jest Nazwa pozycji z Tytułu Artykułu.
   */
  const URL_ARTICLE_TITLE = 1;

  /**
   * Pozycja prowadzaca do Kategorii o ID umieszczonym w polu URL
   */
  const URL_CATEGORY = 2;

  /**
   * Pozycja prowadzaca do Kategorii o ID umieszczonym w polu URL.
   * Pobierana jest Nazwa pozycji z Tytułu Kategorii.
   */
  const URL_CATEGORY_TITLE = 3;

  /**
   * Pozycja prowadzi do reguly z routingu podanej w polu URL
   */
  const URL_ROUTING = 4;

  /**
   * Pozycja prowadzaca do adresu podanego w polu URL
   */
  const URL_RAW = 5;

  /**
   * Pozycja pusta (nigdzie nie prowadzi)
   */
  const URL_EMPTY = 6;

  public static function getUrlTypes() {
    return array(
      self::URL_ARTICLE => 'Artykuł',
      self::URL_ARTICLE_TITLE => 'Artykuł z tytułem',
      self::URL_CATEGORY => 'Kategoria',
      self::URL_CATEGORY_TITLE => 'Kategoria z tytułem',
      self::URL_ROUTING => 'Routing',
      self::URL_RAW => 'Ręczny',
      self::URL_EMPTY => 'Pusty',
    );
  }

  public function hasArticle($menuItem) {
    if ($menuItem['url_type'] == self::URL_ARTICLE || $menuItem['url_type'] == self::URL_ARTICLE_TITLE) {
      return true;
    } else {
      return false;
    }
  }

  public function hasCategory($menuItem) {
    if ($menuItem['url_type'] == self::URL_CATEGORY || $menuItem['url_type'] == self::URL_CATEGORY_TITLE) {
      return true;
    } else {
      return false;
    }
  }

  public function getSettings($key, $menuItem) {
    if (isset($menuItem['json'][$key])) {
      if (is_array($menuItem['json'][$key])) {
        return $menuItem['json'][$key] + $this->settings[$key];
      } else {
        return $menuItem['json'][$key];
      }
    } else {
      if (!isset($this->settings[$key])) {
        throw new sfException('Probojesz pobrac ustawienia o kluczu "' . $key . '" który nie istnieje.');
      } else {
        return $this->settings[$key];
      }
    }
  }

  public function hasSettings($key, $menuItem) {
    if (isset($menuItem['json'][$key])) {
      return true;
    } else {
      return false;
    }
  }

}
