<?php

function inline_edit($object, $model = NULL, $formClass = NULL, $query = NULL) {

  artEscaper::escape($object); 
    
  if (sfContext::getInstance()->getUser()->hasInlineEdit()) {

    $model = sfConfig::get('app_art_cms_plugin_inline_default_model', 'Article');
    $formClass = sfConfig::get('app_art_cms_plugin_inline_default_form', 'ArticleInlineForm');
    $query = sfConfig::get('app_art_cms_plugin_inline_default_query', 'findOneById');

    if (class_exists($model) && class_exists($formClass)) {
      // Przeładowanie obiektu, nadmiarowość danych do formularza,, 
      $object = Doctrine::getTable($model)->$query($object->getId());
      $form = new $formClass($object);
    } else {

      if (!class_exists($model)) {
        throw new sfException(sprintf("Model %s doesn't exist !", $model));
      }

      if (!class_exists($formClass)) {
        throw new sfException(sprintf("Form class %s doesn't exist !", $model));
      }
    }

    echo inline_js($object, $form);

    echo get_partial('frontendManagement/inline_edit_form', array('form' => $form, 'object' => $object
            , 'model' => $model, 'formClass' => $formClass));
  }
}

function inline_js($object, sfForm $form) {
  $sf_user = sfContext::getInstance()->getUser();
  $fieldsArray = array(); 
  $translationFieldsArray = array(); 
  
  foreach ($form as $translationFieldName => $translationFields) {
    array_push($fieldsArray, $translationFieldName); 
    
    foreach ($translationFields as $translationFieldName => $field) {
      array_push($translationFieldsArray, $translationFieldName); 
    }
  }
  
  $formFields = array_unique(array_merge($translationFieldsArray, $fieldsArray)); 
  
  $model = get_class($object); 
  
  $result = '<script type="text/javascript">' . "\n";
  $result .='var Inline'.$model.$object->getId() 
          . ' = new InlineEdit(' . $object->getId() . ',\'' 
          . $form->getName() . '\', \'' 
          . $sf_user->getCulture() . '\', '
          . json_encode($formFields).',\'' 
          . $model . '\');' . "\n";
  
  $result .= '</script>' . "\n";

  return $result;
}

function inline_form_url($params = array()) {
  $url = sfConfig::get('app_art_cms_plugin_inline_routing', '@fm_inline_save');

  $string = $url.'?';
  foreach ($params as $key => $param) {

    $string .= '&' . $key . '=' . $param;
  }
  
  return $string;
}

function inline_attr($object, $element) {
  
  $sf_user = sfContext::getInstance()->getUser();
  artEscaper::escape($object); 
  $id = $object->getId(); 
  
  $model = get_class($object); 
  
  if ($sf_user->hasInlineEdit())
    return " contenteditable=true role=textbox element='$element$model' inlineid='$id' ";
}

function inline_gallery($object){
  $sf_user = sfContext::getInstance()->getUser();
  
  if ($sf_user->isAdmin() && sfConfig::get('app_art_cms_plugin_inline_gallery_enabled', false))
    return get_partial('frontendManagement/inline_gallery_form', array('id' => $object->getId())); 
}

function inline_drag_drop(){
  $sf_user = sfContext::getInstance()->getUser();
  
  if ($sf_user->isAdmin() && sfConfig::get('app_art_cms_plugin_inline_gallery_enabled', false))
    return '<div id="uploader_filelist"><button type="button" onclick="$(\'#uploader_filelist\').hide();$(\'#uploader\').show();" class="close" aria-hidden="true">&times;</button></div>';
}

function inline_gallery_url($params = array()) {
  $url = sfConfig::get('app_art_cms_plugin_inline_gallery_routing', '@fm_gallery_photo_upload');

  $string = $url.'?';
  foreach ($params as $key => $param) {

    $string .= '&' . $key . '=' . $param;
  }
  
  return url_for($string);
}