<?php
/**
 * Klasa ActionBarHelper ulatwia korzystanie z klasy ActionBar w przypadku
 * generowania linkow dla jednego elementu.
 *

 */
abstract class BaseActionBarHelper {
  /** Klasa dataCollector */
  protected static $dataCollectorClass = 'MenuDataCollector';
  /** Wykorzystywana klasa actionBar*/
  protected static $actionBarClass = 'ActionBar';
  /** Wykorzystywana klasa actionBar*/
  protected static $userActionBarClass = 'UserActionBar';
  
  /**
   * Funkcja przygotowuje element zgodnie z wymaganiami przez klase $actionBarClass
   * 
   * @param int $elementId
   * @param boolean $isArticle
   * @param boolean $isReference
   * @return array 
   */
  protected static function prepareElement($element, $isArticle = true, $isReference = false) {
    $dataCollectorClass = self::$dataCollectorClass;
    $prepareElement = array();
    
    if ($isArticle) {
      $prepareElement['type'] = $dataCollectorClass::TYPE_ARTICLE;
    } else {
      $prepareElement['type'] = $dataCollectorClass::TYPE_CATEGORY;
    }
    
    $prepareElement['first'] = false;
    $prepareElement['last'] = false;
    $prepareElement['order_up'] = false;
    $prepareElement['order_down'] = false;
    
    $prepareElement['is_reference'] = $isReference;
    
    return array_merge($element, $prepareElement);
  }
  
  /**
   * Zwraca HTML dla podanego elementu i zdefiniowanych parametrow. Jesli $isArticle jest
   * FALSE to funkcja zaklada ze element jest kategoria. Ustawienie $raw na true zwroci
   * HTML bez przerzucenia go przez cache (znaczniki <?php nie beda przeparsowane przez partial)
   * 
   * @param array $element
   * @param boolean $isArticle
   * @param boolean $isReference
   * @param boolean $raw
   * @return string 
   */
  public static function getActionBar($element = array(), $isArticle = true, $isReference = false, $raw = false ) {
    $element = self::prepareElement($element, $isArticle, $isReference);
    $actionBarClass = self::$actionBarClass;
    $actionBar = new $actionBarClass(array(), self::$dataCollectorClass);
    $content = $actionBar->generateActionBar($element, array());
    
    return ($raw) ? $content : self::getContent($content);
  }
  
  /**
   * Funkcja odpowiada za zawrocenie contentu wykorzystujac cache. Tworzy 
   * partial w cache z przekazanym $content i zwraca go poprzez get_partial().
   * Taki zabieg jest potrzebny aby kod PHP miedzy znacznikami zostal wykonany, 
   * a nie potraktowany jako string.
   * 
   * @param string $content
   * @return string
   * @throws sfException 
   */
  protected static function getContent($content) {
    $partialCacheDir = sfConfig::get('sf_module_cache_dir').'/autoMenu/templates';

    if (!is_dir($partialCacheDir)) {
      mkdir($partialCacheDir, 0777, true);
    }
    
    if (!is_dir($partialCacheDir)) {
      throw new sfException('Katalog "'.$partialCacheDir.'" nie został poprawnie stworzony.');
    }
    
    $partialName = md5('ActionBarHelper');
    $filename = $partialCacheDir . '/_' . $partialName . '.php';
    $file = fopen($filename, 'w+');
    fwrite($file, $content);
    fclose($file);
    chmod($filename, 0777);
    
    if (!is_readable($filename)) {
      throw new sfException('Plik "'.$filename.'" nie został stworzony lub brakuje praw do odczytu');
    }
    
    return get_partial('menu/'.$partialName);
  }
  
  /**
   * Funkcja przygotowuje element zgodnie z wymaganiami przez klase $userActionBarClass
   * 
   * @param int $userId ID Uzytkownika
   * @return array 
   */
  protected static function prepareUserElement($userId, $element) {
    $prepareElement = array();
    $prepareElement['id'] = $userId;
    
    return array_merge($element, $prepareElement);
  }
  
  /**
   * Zwraca HTML dla podanego ID uzytkownika. Ustawienie $raw na true zwroci
   * HTML bez przerzucenia go przez cache (znaczniki <?php nie beda przeparsowane przez partial)
   * 
   * @param int $userId ID Uzytkownika
   * @param array $element Tablica dodatkowych parametrow dla elementu
   * @param boolean $raw Czy ma zwracac HTML przez cache
   * @return string 
   */
  public static function getUserActionBar($userId, $element = array(), $raw = false ) {
    $element = self::prepareUserElement($userId, $element);
    $userActionBarClass = self::$userActionBarClass;
    $userActionBar = new $userActionBarClass(array());
    $content = $userActionBar->generateActionBar($element, array());
    
    return ($raw) ? $content : self::getContent($content);
  }
}
?>
