<?php

/**
 * Klasa odpowiada za wygenerowanie kodu HTML (oraz PHP) zawierajacego
 * ikonke rozwijania menu uzytkownika. Klasa zwiazana z 
 * plikiem manageForm.js
 *

 */
abstract class BaseUserActionBar {

  protected $settings = array();
  protected $links = array();
  protected $object = null;

  /**
   * Konstruktor przyjmuje ustawienia w postaci tablicy
   * 
   * @param array $settings
   */
  public function __construct($settings = array()) {

    $this->initSettings($settings);
    $this->user = $this->getUser();

    // Rejestrujemy dostepne linki
    $this->registerLink('article_add');
    $this->registerLink('change_password');
    //$this->registerLink('show_fm_icons');
    //$this->registerLink('hide_fm_icons');
    $this->registerLink('toggle_translations');
    $this->registerLink('translations_list');
    $this->registerLink('art_configuration_list');
    $this->registerLink('logout');
  }

  protected function getChangePassword() {
    if ($this->user->isAuthenticated()) {
      $data = $this->prepareLink();
      $data['a']['onclick'] = "ManageForm.changePassword(this, '" . $this->user->getId() . "');";
      $data['i']['class'] .= " megaicon1-key";
      $data['text'] = __('Zmień hasło');
      return $data;
    } else {
      return false;
    }
  }

  protected function getArticleAdd() {
    $data = $this->prepareLink();

    $data['a']['onclick'] = "ManageForm.articleAdd(this);";
    $data['i']['class'] .= " megaicon1-plus";

    $data['text'] = __('Dodaj artykuł');
    
    return $data;
  }

  protected function getShowFmIcons() {
    if ($this->user->isAuthenticated()) {
      $data = $this->prepareLink();
      $data['a']['onclick'] = "showFMIcons();";
      $data['i']['class'] .= " megaicon1-eye-view-1";
      $data['li']['class'] .= " hide";
      $data['text'] = __('Pokaż ikonki');
      return $data;
    } else {
      return false;
    }
  }

  protected function getHideFmIcons() {
    if ($this->user->isAuthenticated()) {
      $data = $this->prepareLink();
      $data['a']['onclick'] = "hideFMIcons();";
      $data['i']['class'] .= " megaicon1-eye";
      $data['text'] = __('Ukryj ikonki');
      return $data;
    } else {
      return false;
    }
  }

  protected function getToggleTranslations() {
    if ($this->user->isAuthenticated() && $this->user->isTranslator()) {
      $data = $this->prepareLink();
      $data['a']['href'] = url_for('@set_i18n');
      $data['i']['class'] .= " megaicon1-flag";
      if (!$this->user->getAttribute('i18n_edit')) {
        $data['text'] = __('Włącz edycję tłumaczeń');
      } else {
        $data['text'] = __('Wyłącz edycję tłumaczeń');
      }
      return $data;
    } else {
      return false;
    }
  }

  protected function getTranslationsList() {
    if ($this->user->isAuthenticated() && $this->user->isTranslator()) {
      $data = $this->prepareLink();
      $data['a']['onclick'] = "artI18nTranslationsList();";
      $data['i']['class'] .= " megaicon1-flag";
      $data['text'] = __('Lista tłumaczeń');
      return $data;
    } else {
      return false;
    }
  }

  protected function getArtConfigurationList() {
    if ($this->user->isAuthenticated() && $this->user->isAdmin()) {
      $data = $this->prepareLink();
      $data['a']['onclick'] = "ManageForm.artConfigurationList(this, 1);";
      $data['i']['class'] .= " megaicon1-settings";
      $data['text'] = __('Konfiguracja');
      return $data;
    } else {
      return false;
    }
  }

  protected function getLogout() {
    if ($this->user->isAuthenticated()) {
      $data = $this->prepareLink();
      $data['a']['href'] = url_for("@sf_guard_signout");
      $data['i']['class'] .= " megaicon1-close-off-2";
      $data['text'] = __('Wyloguj');
      return $data;
    } else {
      return false;
    }
  }

  /**
   * Funkcja inicjuje ustawienia. Wykorzystuje getDefaultSettings() i tablice
   * parametrow.
   * 
   * @param array $settings
   */
  protected function initSettings($settings) {
    $this->settings = $settings + $this->getDefaultSettings();
  }

  /**
   * Funkcja zwraca wartosci default dla ustawien.
   * 
   * @return array
   */
  protected function getDefaultSettings() {
    return array(
      'blacklist' => null, // Tablica z wyłaczonymi linkami dod anego FM AcB.
      'whitelist' => null, // Tablica z właczonymi linkami dod anego FM AcB.
      'enabled' => true,
      'empty_url' => 'javascript:void(0);',
      'div' => array(
        'class' => 'options-container user-action-bar',
      ),
      'options_icon' => array(
        'class' => 'cp megaicon1-wrench frontend-management',
        'onclick' => 'toggleActionBar(this);',
      ),
      'ul' => array(
        'class' => 'action-bar actionbar-menu indicator hide',
      ),        
      'li' => array(
      ),
      'a' => array(
      ),
      'i' => array(
          'class' => '',
      ),
    );
  }

  /**
   * Rejestruje link do wstawiania do menu zarzadzania
   */
  protected function registerLink($link) {
    if (isset($this->settings['blacklist']) && is_array($this->settings['blacklist'])) {
      $blackList = $this->settings['blacklist'];

      if (!in_array($link, $blackList)) {
        $this->links[] = $link;
      }
    } elseif (isset($this->settings['whitelist']) && is_array($this->settings['whitelist'])) {
      $whiteList = $this->settings['whitelist'];

      if (in_array($link, $whiteList)) {
        $this->links[] = $link;
      }
    } else {
      $this->links[] = $link;
    }
  }

  protected function prepareLink() {
    $data = array(
      'li' => $this->settings['li'],
      'a' => $this->settings['a'],
      'i' => $this->settings['i'],
    );

    $data['a']['href'] = $this->settings['empty_url'];

    return $data;
  }

  /**
   * Funkcja zwraca HTML i kod PHP na podstawie podanego
   * klucza linku do wygenerowania $link i przekazego elementu
   * 
   * @param string $link
   * @param array $element
   * @param array $elementData
   * @return string 
   */
  protected function generateLink($link, $linkData) {
    $content = tag('li', $linkData['li']);
    
    $content .= tag('a', $linkData['a']);

    $content .= content_tag('i', '', $linkData['i']).' '.$linkData['text'];

    $content .= '</a></li>';

    return $content;
  }

  protected function checkLinks() {
    foreach ($this->links as $link) {
      if ($this->checkLink($link)) {
        return true;
      }
    }

    return false;
  }

  protected function getUser() {
    return sfContext::getInstance()->getUser();
  }

  protected function checkLink($link) {
    $method = 'get' . sfInflector::camelize($link);
    if (method_exists($this, $method)) {
      if (!$this->getUser()->hasFmLink($link)) {
        return false;
      }

      $generate = $this->$method();

      if ($generate === false) {
        return false;
      } else {
        return true;
      }
    } else {
      throw new sfException('Brak metody "' . $method . '" do generowania linka.');
    }
  }

  protected function generateLinks() {
    $content = '';
    foreach ($this->links as $link) {
      // Sprawdzamy czy metoda istnieje i uzytkownik ma prawo do wyswietlenia linku
      if ($this->checkLink($link)) {
        $method = 'get' . sfInflector::camelize($link);
        $linkData = $this->$method();
        $content .= $this->generateLink($link, $linkData);
      }
    }

    return $content;
  }

  /**
   * Funkcja odpowiedzialna za caly proces tworzenia ikonki i menu paska akcji.
   * Jesli 'enabled' = false lub 'app_fm_enabled' = false - nic nam nie zwroci. 
   * W przeciwnym wypadku zwraca kod HTML i PHP zawierajacy ikonke i menu paska
   * akcji.
   * 
   * @return string 
   */
  public function generateActionBar() {
    // Sprawdzamy czy jest wszystko powlaczane i czy wogule uzytkownik ma prawa
    // do wyswietlenia chociaz jednego linku
    if (!$this->settings['enabled'] || !$this->checkLinks()) {
      // Jesli jest nie aktywny lub wylaczony w app.yml to nic nie zwracaj
      return '';
    } else {
      $content = tag('div', $this->settings['div']);
            $content .= tag('i', $this->settings['options_icon']);

      $content .= content_tag('ul', $this->generateLinks(), $this->settings['ul']);

      $content .= '</i>';
      $content .= '</div>';

      return $content;
    }
  }

  public function __toString() {
    try {
      return $this->generateActionBar();
    } catch (Exception $ex) {
      return $ex->getMessage();
    }
  }

}
