<?php

/**
 * PluginArticle
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @package    ##PACKAGE##
 * @subpackage ##SUBPACKAGE##
 * @author     ##NAME## <##EMAIL##>
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class PluginArticle extends BaseArticle {

  /**
   * Parametry Layoutu przypisanego do kategorii. 
   * 
   * @var type 
   */
  public $layoutParams = array();
  public $layoutParamsInitiated = false;

  /**
   * Pobiera parametry i zapisuje do array w obiekcie. 
   */
  public function getLayoutParams() {

    foreach ($this->getLayout()->getLayoutParams() as $key => $param) {

      $this->layoutParams[$param->getName()] = $param->getValue();
    }
  }

  /**
   * Sprawdza czy parametr jest ustawiony. 
   * 
   * @param type $name
   * @return type
   */
  public function hasParam($name) {
    if (!$this->layoutParamsInitiated) {
      $this->getLayoutParams();
      $this->layoutParamsInitiated = true;
    }
    
    return isset($this->layoutParams[$name]) ? $this->layoutParams[$name] : false;
  }

  /**
   * Zwraca value parametu. 
   * 
   * @param type $name
   * @param type $default
   * @return type
   */
  public function getParam($name, $default = null) {
    
    if (!$this->layoutParamsInitiated) {
      $this->getLayoutParams();
      $this->layoutParamsInitiated = true;
    }
    
    return (isset($this->layoutParams[$name]) && $this->layoutParams[$name] != '') ? $this->layoutParams[$name] : $default;
  }
  
  public function hasStartAt() {
    return $this->hasParam('start_at', sfConfig::get('app_art_cms_plugin_article_start_at', false));
  }
  
  /**
   * Zwraca link do artykułu.
   * 
   * @param type $params
   * @return boolean
   */
  public function getUrl($params = array()) {
    if ($this->getIsDisplayed() && $this->getFlag() != 'no_redirect') {
      $context = sfContext::getInstance();
      if (!isset($params['slug'])) {
        $params['slug'] = $this->getSlug();
      }

      $category = $this->getCategories()->getFirst();

      if (!isset($params['category']) && !empty($category)) {
        $params['category'] = $category->getSlug();
      }

      if (empty($category)) {
        return $context->getRouting()->generate('redirector', $params);
      } else {
        return $context->getRouting()->generate('redirector_category', $params);
      }
    } else {
      return false;
    }
  }

  public function getEscapedTitle() {

    return strip_tags(htmlspecialchars_decode(parent::getTitle()));
  }

  public function getShortDescriptionHtml() {

    echo htmlspecialchars_decode(parent::getShortDescription());
  }

  public function getDescriptionHtml() {

    echo htmlspecialchars_decode(parent::getDescription());
  }

  public function getEscapedShortDescription() {

    return strip_tags(htmlspecialchars_decode(parent::getShortDescription()));
  }

  public function getImagesCount() {

    return $this->getArticlePhotoesOrdered()->count();
  }

  public function getImageAlt() {

    return ($this->getTitle() != '') ? str_replace('"', "''", $this->getTitle()) : ' ';
  }

  /**
   * Czy Artykuł ma wogule jakas treść.
   * Mozemy korzystac z Artykułu jako Galeria.
   * @return boolean
   */
  public function hasContents() {
    return true;
    return ($this->hasTitle() || $this->hasShortDescription() || $this->hasDescription());
  }

  public function hasDescription() {
    return $this->getParam('description', true);
  }

  public function hasLayoutBigImage() {
    return $this->hasParam('big_image');
  }
  
  public function hasLayoutCategories() {
    return $this->getParam('categories', false);
  }

  public function hasVideo() {
    return $this->hasParam('video');
  }

  public function hasGoogleMap() {
    return $this->hasParam('google_map');
  }

  public function hasCreatedAt() {
    return $this->hasParam('created_at');
  }

  public function hasToggle() {
    return $this->hasParam('toogle');
  }

  public function hasSocials() {
    return $this->hasParam('socials');
  }

  public function hasBack() {
    return $this->hasParam('back');
  }

  public function hasBreadcrumbs() {
    return $this->hasParam('breadcrumbs');
  }

  public function getCreator() {
    return $this->getSfGuardUser();
  }

  public function hasShortDescription() {
    return $this->hasParam('short_description');
  }

  public function hasViews() {
    return $this->hasParam('views');
  }

  public function hasTitle() {
    return true;
    return $this->hasParam('title', true);
  }

  public function hasCreatedAtCallendar() {
    return $this->hasParam('created_at');
  }

  public function hasComments() {
    return $this->hasParam('comments');
  }

  public function hasContactForm() {
    return $this->hasParam('contact_form');
  }

  public function hasContactInfo() {
    return $this->hasParam('contact_info');
  }

  public function hasGallery() {
    return $this->hasParam('gallery');
  }

  public function hasAuthor() {
    return $this->hasParam('author');
  }

  public function hasMeta() {
    return $this->hasAuthor() || $this->hasTags() || $this->hasViews();
  }

  public function hasLayoutTags() {
    return $this->hasParam('tags');
  }

  public function hasTags() {
    return $this->hasParam('tags') && $this->getTags()->count() > 0;
  }

  public function hasTitleImageForForm() {
    $titleImage = $this->getTitleImage();
    return (isset($titleImage) && $titleImage !== '' && file_exists(self::getTitleImageAbsolutePath() . $filename));
  }

  public function hasLayoutTitleImage() {
    return $this->hasParam('title_image');
  }

  public function hasHeaderOnTop() {
    return $this->hasParam('header_on_top');
  }

  public function hasTitleImage() {
    return $this->hasTitleImageForForm() && $this->hasLayoutTitleImage();
  }

  public function hasBigImage() {
    $bigImage = $this->getBigImage();

    return (isset($bigImage) && $bigImage != '' && file_exists(self::getBigImageAbsolutePath() . $bigImage));
  }
  
  public function getArticlePhotoBigImageWidth() {
      return $this->getParam('img_medium_width', 1920);
  }
  
  public function getArticlePhotoBigImageHeight() {
      return $this->getParam('img_big_height', 1080);
  }
  
  /**
   * 
   * @return string
   */
  public function getBigImageSrc() {
    $bigImage = $this->getBigImage();
    $articleConf = sfConfig::get('app_art_cms_plugin_article');
    
    $width = 500;
    $height = 500;
    if (isset($articleConf['big_image']['width'])) {
      $width = $articleConf['big_image']['width'];
    }
    if (isset($articleConf['big_image']['height'])) {
      $height = $articleConf['big_image']['height'];
    }
    
    $width  = $this->getParam('big_image_width', $width);
    $height = $this->getParam('big_image_height', $height);
    
    if ($bigImage != ''){
      $fileSrc = self::getBigImageAbsolutePath() . $bigImage; 
      
      if (!is_file($fileSrc)){
        $fileSrc = sfContext::getInstance()->getRouting()->generate('placehold').'?'.$width.'-'.$height.'-CCCCCC-969696'; 
      } else {
        $fileSrc = self::getBigImagePath() . $bigImage;
      }
      
    } else {
      
      $fileSrc = sfContext::getInstance()->getRouting()->generate('placehold').'?'.$width.'-'.$height.'-CCCCCC-969696'; 
    }
    
    return $fileSrc; 
  }
  
  /**
   * 
   * @return string
   */
  public function getTitleImageSrc() {
    $titleImage = $this->getTitleImage();
    
    $width  = $this->getParam('title_image_width', ArtConfiguration::getArtCmsArticleTitleImageWidth()); 
    $height = $this->getParam('title_image_height', ArtConfiguration::getArtCmsArticleTitleImageHeight()); 

    if ($titleImage != ''){
      $fileSrc = self::getTitleImageAbsolutePath() . $titleImage; 
      
      if (!is_file($fileSrc)){
        $fileSrc = sfContext::getInstance()->getRouting()->generate('placehold').'?'.$width.'-'.$height.'-CCCCCC-969696&text='.$width.'x'.$height; 
      } else{
        $fileSrc = self::getTitleImagePath() . $titleImage; 
      }
      
    } else {
      $fileSrc = sfContext::getInstance()->getRouting()->generate('placehold').'?'.$width.'-'.$height.'-CCCCCC-969696&text='.$width.'x'.$height;
    }
    
    return $fileSrc; 
  }

  public static function getTitleImagePath() {
    return '/uploads/' . sfConfig::get('app_article_title_image_path', 'articles/title/');
  }

  public static function getTitleImageAbsolutePath() {
    return sfConfig::get('sf_upload_dir') . '/' . sfConfig::get('app_article_title_image_path', 'articles/title/');
  }

  public static function getBigImagePath() {
    return '/uploads/' . sfConfig::get('app_article_big_image_path', 'articles/big/');
  }

  public static function getBigImageAbsolutePath() {
    return sfConfig::get('sf_upload_dir') . '/' . sfConfig::get('app_article_big_image_path', 'articles/big/');
  }

  /**
   * Zwraca sciezke do plikow galerii danego artykulu
   * @param boolean $absolute Czy zwrocic pelna sciezke
   * @param string $size Typ fotografii: big, medium, small
   * @return string
   */
  public function getGalleryPath($size = null, $absolute = false) {
    $path = '/uploads/articles/' . $this->getId() . '/';

    if ($absolute) {
      $path = sfConfig::get('sf_web_dir') . $path;
    }
    if (!is_null($size)) {
      $path .= $size . '/';
    }

    return $path;
  }

  public function getBigGalleryPath() {
    return $this->getGalleryPath('big');
  }

  public function getMediumGalleryPath() {
    return $this->getGalleryPath('medium');
  }

  public function getSmallGalleryPath() {
    return $this->getGalleryPath('small');
  }

  public function getGalleryAbsolutePath($size = null) {
    return $this->getGalleryPath($size, true);
  }

  public function isDisplayedAndActive() {
    return $this->getIsDisplayed() && $this->isActive();
  }

  public function isActive() {
    $startAt = $this->getStartAt();
    $expireAt = $this->getExpireAt();

    return (!isset($startAt) || $startAt <= artDate::today()) && (!isset($expireAt) || $expireAt >= artDate::today());
  }

  public function getPermissionsNames() {
    $permissions = $this->getPermissions();
    $articlePermissions = array();

    foreach ($permissions as $permission) {
      $articlePermissions[] = $permission->getName();
    }

    return $articlePermissions;
  }

  public function canBeDeleted() {
    return true;
  }

  public function getFirstBigPhoto($absolute = false) {

    $gallery = $this->getArticlePhotoes();

    return $this->getGalleryPath('big', $absolute) . $gallery[0]->getBigImage();
  }

  public function getFirstMediumPhoto($absolute = false) {

    $gallery = $this->getArticlePhotoesOrdered();

    return $this->getGalleryPath('medium', $absolute) . $gallery[0]->getMediumImage();
  }

  public function getFirstSmallPhoto($absolute = false) {

    $gallery = $this->getArticlePhotoesOrdered();

    return $this->getGalleryPath('small', $absolute) . $gallery[0]->getSmallImage();
  }

  public function getCommentsCount() {
    return $this->getArticleComments()->count();
  }

  public static function deleteCategoriesList(array $articleCategoryArrayToDelete) {

    foreach ($articleCategoryArrayToDelete as $articleCategory) {
      $deleted = Doctrine_Query::create()
          ->delete()
          ->from('ArticleCategory')
          ->where('id = ?', $articleCategory)
          ->execute();
    }
  }

  public static function orderCmp($a, $b) {
    if ($a->getOrder() == $b->getOrder()) {
      return 0;
    }
    return ($a->getOrder() < $b->getOrder()) ? -1 : 1;
  }

  public function getArticlePhotoesOrdered() {
    $photoes = parent::getArticlePhotoes();

    return artCollectionSorter::sort($photoes, 'order', 'asc');
  }

  public function getArticleFilesOrdered() {
    $files = parent::getArticleFiles();

    return artCollectionSorter::sort($files, 'order', 'asc');
  }

  protected function recursiveUnset(&$array, $unwanted_key) {
    unset($array[$unwanted_key]);
    foreach ($array as &$value) {
      if (is_array($value)) {
        $this->recursiveUnset($value, $unwanted_key);
      }
    }
  }

  /**
   * Funkcja uzupelnia NOWY obiekt wykorzystujac podana tablice.
   * Napisana ze wzgledu na to ze funkcja copy() ma wyciek pamieci przy wielu relacjach
   * (dokladnie na ArticlePhoto)
   * @param array $data
   */
  public function copyFromArray(array $data) {
    $oldId = $data['id'];
    // Usuwamy wszystkie wpisy w tablicach z ID bo chcemy miec obiekty z nowymi ID
    $this->recursiveUnset($data, 'id');
    foreach ($data['Translation'] as $culture => &$record) {
      $record['slug'] = md5($this->getTitle() . '-' . rand(10, 1000) . '-' . rand(1000, 123123));
    }
    $this->fromArray($data);
    $this->setUniqueName(NULL);
    $this->setCreatedAt(artDate::today());
    $this->setUpdatedAt(artDate::today());

    $this->save();
    foreach ($this->getArticleCategories() as $articleCategory) {
      $articleCategory->setArticleId($this->getId());
    }
    foreach ($this->getArticlePhotoes() as $articlePhoto) {
      $articlePhoto->setArticleId($this->getId());
    }

    $this->save();
    // Kopiowanie zdjec
    try {
      $fileSystem = new sfFilesystem();
      $articleUploadDir = sfConfig::get('sf_upload_dir') . '/articles/';
      $fileSystem->execute('cp -r ' . $articleUploadDir . $oldId . ' ' . $articleUploadDir . $this->getId());
    } catch (Exception $exc) {
      
    }
  }

  public function preDelete($con = null) {

    $objects = Doctrine::getTable('MenuItem')->createQuery('mi')
            ->whereIn('mi.url_type', array(GroupMenu::URL_ARTICLE, GroupMenu::URL_ARTICLE_TITLE))
            ->leftJoin('mi.Translation mit')
            ->andWhere('mit.url = ?', $this->getId())->execute();

    foreach ($objects as $object) {
      $object->delete();
    }

    $this->clearCache();
    parent::preDelete($con);
  }

  /**
   * Usuwa zdjęcia z artykułu. 
   * 
   * @param type $event
   */
  public function postDelete($event) {
    $dir = sfConfig::get('sf_upload_dir') . '/articles/' . $this->getId();

    if (file_exists($dir))
      sfToolkit::clearDirectory($dir);

    $fs = new sfFilesystem();
    if (file_exists($dir))
      $fs->remove($dir);
  }
  

  public function postSave($con = null) {

    $this->clearCache();
    parent::postSave($con);
  }

  
  public function clearCache() {
    $cacheDir = sfConfig::get('sf_cache_dir') . '/';
    $cache = new sfFileCache(array('cache_dir' => $cacheDir));
    $cache->clean();
  }

}
