<?php

/**
 * PluginArticleCategoryTable
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 */
class PluginArticleCategoryTable extends artDoctrineTable {

  /**
   * Returns an instance of this class.
   *
   * @return object PluginArticleCategoryTable
   */
  public static function getInstance() {
    return Doctrine_Core::getTable('PluginArticleCategory');
  }

  public function getArticlesAndSubcategories($categoryId) {
    $culture = $this->getUserCulture();

    return $this->createQuery('ca')
                    ->leftJoin('ca.Article a')
                    ->leftJoin("a.Translation at WITH at.lang='$culture'")
                    ->leftJoin('ca.SubCategory sc')
                    ->leftJoin("sc.Translation sct WITH sct.lang='$culture'")
                    ->where('ca.category_id = ?', $categoryId)
                    ->orderBy('ca.order ASC')
                    ->execute();
  }

  public function updateOrder($articleCategoryId, $order) {
    $this->createQuery()
            ->update()
            ->set('order', $order)
            ->where('id = ?', $articleCategoryId)
            ->execute();
  }

  public function increaseOrderInCategory($categoryId) {
    $this->createQuery()
            ->update()
            ->set('order', '(order+1)')
            ->where('category_id = ?', $categoryId)
            ->execute();
  }

  public function getArticlesByCategoryUniqueName($categoryUniqueName, $limit = -1) {
    $q = $this->getArticlesQueryPart()
            ->andWhere('c.unique_name = ?', $categoryUniqueName);
    if ($limit > 0)
      $q->limit($limit);

    return $q->execute();
  }

  public function getArticlesByCategoryId($categoryId) {
    return $this->getArticlesQueryPart()
                    ->where('ac.category_id = ?', $categoryid)
                    ->execute();
  }

  public function getArticlesQueryPart() {
    $culture = $this->getUserCulture();
    $date = artDate::today();

    return $this->createQuery('ac')
                    ->leftJoin('ac.Category c')
                    ->leftJoin('ac.SubCategory sc')
                    ->leftJoin("sc.Translation sct WITH sct.lang='$culture'")
                    ->leftJoin('ac.Article a')
                    ->leftJoin("a.Translation at WITH at.lang='$culture'")
//            ->where('a.is_displayed = ?', 1)
//            ->andWhere("((a.start_at IS NULL AND a.expire_at IS NULL) OR (a.start_at > '$date' AND a.expire_at < '$date'))")
                    ->orderBy('ac.order ASC');
  }

  public function getSubcategory($categoryUniqueName) {
    $culture = $this->getUserCulture();

    return $this->createQuery('ac')
                    ->leftJoin('ac.Category c')
                    ->leftJoin('ac.SubCategory sc')
                    ->leftJoin("c.Translation act WITH act.lang='$culture'")
                    ->where('c.unique_name = ?', $categoryUniqueName)
                    ->orderBy('ac.order')
                    ->execute();
  }

  public function getCategoryByUniqueName($categoryUniqueName) {
    return $this->createQuery('ac')
                    ->leftJoin('ac.Category c')
                    ->where('c.unique_name = ?', $categoryUniqueName)
                    ->fetchOne();
  }

  public function getCategoryBySlug($slug) {

    $culture = $this->getUserCulture();

    return $this->createQuery('ac')
                    ->leftJoin('ac.Category c')
                    ->leftJoin("c.Translation ct WITH ct.lang='$culture'")
                    ->where('ct.slug = ?', $slug)
                    ->fetchOne();
  }

  public function getArticleCountOfCategory($uniqueName) {
    return $this->createQuery('ac')
                    ->select('count(*)')
                    ->leftJoin('ac.Category c')
                    ->where('c.unique_name = ?', $uniqueName)
                    ->fetchOne();
  }

  public function deleteForSubcategories($categoryId, $subcategoriesIds) {
    $this->createQuery()
            ->delete()
            ->whereIn('subcategory_id', $subcategoriesIds)
            ->andWhere('category_id = ?', $categoryId)
            ->execute();
  }

  public function deleteRepeatedCategoriesIds() {
    $this->createQuery()
            ->delete()
            ->where('(subcategory_id = category_id)')
            ->execute();
  }

  /**
   * Funkcja zlicza ilosc artykulow w kategorii o podanym ID.
   * 
   * @param integer $categoryId
   * @param boolean $createdAtLessThanNow
   * @param date $createdAt
   * @return int  
   */
  public function getArticleCountOfCategoryId($categoryId, $createdAtLessThanNow = false, $createdAt = null) {
    $query = $this->createQuery('ac')
            ->leftJoin('ac.Article a')
            ->where('ac.category_id = ?', $categoryId)
            ->andWhere('ac.subcategory_id IS NULL')
            ->andWhere('a.is_displayed = ?', 1);

    if ($createdAtLessThanNow) {
      $query->andWhere('a.created_at <= NOW()');
    }
    if ($createdAt != null) {
      $query->andWhere('DATE(a.created_at) = ?', $createdAt);
    }

    return $query->count();
  }

  /**
   * Funkcja sprawdza czy artykul o danym ID jest juz w  kategorii o danym ID.
   * Jeśli zmienna $returnObject jest ustawiona to funkcja zwroci nam obiekt
   * jesli istnieje.
   * 
   * @param integer $articleId
   * @param integer $categoryId
   * @param boolean $returnObject
   * @return boolean / ArticleCategory
   
   */
  public static function isArticleInCategory($articleId, $categoryId, $returnObject = false) {
    $object = ArticleCategoryTable::getInstance()->createQuery('ac')
            ->where('ac.article_id = ? ', $articleId)
            ->andWhere('ac.category_id = ? ', $categoryId)
            ->andWhere('ac.subcategory_id IS NULL')
            ->fetchOne();

    if ($object) {
      if ($returnObject) {
        return $object;
      } else {
        return true;
      }
    }

    return false;
  }

  /**
   * Funkcja dodaje artykuł o danym ID do kategorii o danym ID.
   * Funkcja posiada opcje $safeMode, domyslnie TRUE. Jesli ustawiona sprawdza 
   * czy dany artykul nalezy do kategorii, jesli nie nalezy to dodaje.
   * Zwraca TRUE jesli dodano nowe polaczenie.
   * 
   * @param integer $articleId
   * @param integer $categoryId
   * @param boolean $safeMode
   * @return boolean 
   
   */
  public static function addArticleToCategory($articleId, $categoryId, $safeMode = true) {
    if ($safeMode && ArticleCategoryTable::isArticleInCategory($articleId, $categoryId)) {
      return false;
    } else {
      $object = new ArticleCategory();
      $object->setArticleId($articleId);
      $object->setCategoryId($categoryId);
      $object->save();

      return true;
    }
  }

  /**
   * Funkcja usuwa artykuł o danym ID z kategorii o danym ID.
   * Zwraca TRUE jesli usunieto polaczenie, FALSE w przeciwnym wypadku.
   * 
   * @param integer $articleId
   * @param integer $categoryId
   * @return boolean 
   
   */
  public static function deleteArticleFromCategory($articleId, $categoryId) {
    $object = ArticleCategoryTable::isArticleInCategory($articleId, $categoryId, true);
    if ($object) {
      $object->delete();
      return true;
    }

    return false;
  }

  public function getCategoriesByUniqueName($categoryUniqueName) {

    $culture = $this->getUserCulture();

    $category = Doctrine::getTable('Category')->findOneByUniqueName($categoryUniqueName);

    if (!$category)
      return false;

    $categoryId = $category->getId();


    return $this->createQuery('ac')
                    ->leftJoin('ac.Category c')
                    ->leftJoin('ac.SubCategory sc')
                    ->leftJoin("sc.Translation sct WITH sct.lang='$culture'")
                    ->where('ac.category_id = ?', $categoryId)
                    ->andWhere('ac.article_id IS NULL')
                    ->execute();
  }
  
  public function getOrderedRecords($categoryId) {
    return $this->createQuery('ac')
            ->leftJoin('ac.Article a')
            ->where('ac.category_id = ?', $categoryId)
            ->andWhere('a.is_displayed = ?', 1)
            ->orderBy('ac.order ASC')
            ->execute();
  }

  /** MenuDataCollector * */

  /**
   * Funkcja pobiera rekordy ArticleCategory uzywajac unique_name jednej kategorii,
   * sortuje po order. Moze pobrac same artykuly lub kategorie.
   * @param string $uniqueName
   * @param boolean $withArticles
   * @param boolean $withCategories
   * @return array 
   */
  public function getByUniqueName($uniqueName, $withArticles = true, $withCategories = true) {
    $query = $this->createQuery('ac')
            ->select('ac.category_id')
            ->leftJoin('ac.Category c')
            ->where('c.unique_name = ?', $uniqueName)
            ->orderBy('ac.order ASC');

    $rootAlias = $query->getRootAlias();

    if ($withArticles) {
      $query->addSelect($rootAlias . '.article_id');
      $query->leftJoin($rootAlias . '.Article a');
      $query->andWhere('(a.is_displayed = ? OR ' . $rootAlias . '.article_id IS NULL)', 1);
    } else {
      $query->andWhere($rootAlias . '.article_id IS NULL');
    }

    if ($withCategories) {
      $query->addSelect($rootAlias . '.subcategory_id');
    } else {
      $query->andWhere($rootAlias . '.subcategory_id IS NULL');
    }

    return $query->fetchArray();
  }

  /**
   * Funkcja pobiera rekordy ArticleCategory uzywajac tablicy category_id,
   * sortuje po order. Moze pobrac same artykuly lub kategorie.
   * @param string $uniqueName
   * @param boolean $withArticles
   * @param boolean $withCategories
   * @return array 
   */
  public function getByCategoryIds($categoryIds, $withArticles = true, $withCategories = true) {
    $query = $this->createQuery('ac')
            ->select('ac.category_id, ac.id')
            ->whereIn('ac.category_id', $categoryIds)
            ->orderBy('ac.order ASC');

    $rootAlias = $query->getRootAlias();

    if ($withArticles) {
      $query->addSelect($rootAlias . '.article_id');
      $query->leftJoin($rootAlias . '.Article a');
      $query->andWhere('(a.is_displayed = ? OR ' . $rootAlias . '.article_id IS NULL)', 1);
    } else {
      $query->andWhere($rootAlias . '.article_id IS NULL');
    }

    if ($withCategories) {
      $query->addSelect($rootAlias . '.subcategory_id');
    } else {
      $query->andWhere($rootAlias . '.subcategory_id IS NULL');
    }

    return $query->fetchArray();
  }

  /** KONIEC - MenuDataCollector * */
  /** FrontendManagement * */

  /**
   * Funkcja zwraca najwyzszy order dla podanego $categoryId. Bierze pod uwage
   * kategorie i artykuly przypisane do kategorii. Jesli nic nie jest jeszcze
   * przypisane do kategorii zwraca -1.
   * @param int $categoryId 
   * @return int
   *
   */
  public function getMaxOrder($categoryId) {
    $result = $this->createQuery('ac')
            ->select('MAX(ac.order) as max_order')
            ->where('ac.category_id = ?', $categoryId)
            ->groupBy('ac.category_id')
            ->fetchOne(array(), Doctrine::HYDRATE_ARRAY);
    return (is_null($result['max_order']) ? -1 : $result['max_order']);
  }

  /**
   * Funkcja zamienia order w rekordzie ArticleCategory o podanym ID i rekordzie
   * majacym order wiekszy o 1. Rekord "majacy order wiekszy o 1"
   * pobierany jest na podstawie 'category_id' i 'order' (zwiekszonego o 1)
   * rekordu bazowego. W przypadku niepowodzenia zwraca FALSE
   * 
   * @param int $id
   * @return boolean 
   */
  public function orderUp($id) {
    $object = $this->createQuery('ac')
            ->where('ac.id = ?', $id)
            ->fetchOne();

    if (!$object) {
      return false;
    }

    $object2 = $this->createQuery('ac')
            ->where('ac.order = ?', $object->getOrder() + 1)
            ->andWhere('ac.category_id = ?', $object->getCategoryId())
            ->fetchOne();

    if (!$object2) {
      return false;
    }

    $object->setOrder($object->getOrder() + 1);
    $object->save();
    $object2->setOrder($object2->getOrder() - 1);
    $object2->save();

    return true;
  }

  /**
   * Funkcja zamienia order w rekordzie ArticleCategory o podanym ID i rekordzie
   * majacym order mniejszy o 1. Rekord "majacy order mniejszy o 1"
   * pobierany jest na podstawie 'category_id' i 'order' (zmniejszonego o 1)
   * rekordu bazowego. W przypadku niepowodzenia zwraca FALSE
   * 
   * @param int $id
   * @return boolean 
   */
  public function orderDown($id) {
    $object = $this->createQuery('ac')
            ->where('ac.id = ?', $id)
            ->fetchOne();

    if (!$object) {
      return false;
    }

    $object2 = $this->createQuery('ac')
            ->where('ac.order = ?', $object->getOrder() - 1)
            ->andWhere('ac.category_id = ?', $object->getCategoryId())
            ->fetchOne();

    if (!$object2) {
      return false;
    }

    $object->setOrder($object->getOrder() - 1);
    $object->save();
    $object2->setOrder($object2->getOrder() + 1);
    $object2->save();

    return true;
  }

  /**
   * Ustawia kolejnosc orderow dla kategorii z $id (ArticleCategory ID)
   * @param int $id ArticleCategory ID
   */
  public function repairOrder($id) {
    $objects = $this->createQuery('ac')
            ->where('ac.category_id = (SELECT ac2.category_id FROM ArticleCategory ac2 WHERE ac2.id = ?)', $id)
            ->orderBy('ac.order ASC')
            ->execute();

    $order = 0;
    foreach ($objects as $object) {
      $object->setOrder($order);
      $object->save();
      $order++;
    }
  }

  /** KONIEC - FrontendManagement * */
}
