<?php

/**
 * PluginArticleCommentTable
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 */
class PluginArticleCommentTable extends artDoctrineTable
{

  /**
   * Returns an instance of this class.
   *
   * @return object PluginArticleCommentTable
   */
  public static function getInstance()
  {
    return Doctrine_Core::getTable('PluginArticleComment');
  }

  public function getBackendList(Doctrine_Query $query)
  {
    $rootAlias = $query->getRootAlias();
    $articleId = $this->getRequestParameter('id');

    $query->leftJoin($rootAlias . '.Article art')
            ->leftJoinTranslation('art')
            ->leftJoin($rootAlias . '.sfGuardUser sfgu')
            ->where('art.id = ?', $articleId);

    return $query;
  }
  
  public function getFrontendList(Doctrine_Query $query)
  {
    $rootAlias = $query->getRootAlias();
    $articleId = $this->getRequestParameter('id');

    $query->leftJoin($rootAlias . '.Article art')
            ->leftJoinTranslation('art')
            ->leftJoin($rootAlias . '.sfGuardUser sfgu')
            ->where('art.id = ?', $articleId);

    return $query;
  }

  public function getCommentForArticle($articleId)
  {
    return $this->createQuery()
            ->where('article_id = ?', $articleId)
            ->andWhere('display = ?', 1)
            ->execute();
  }

  public function removeComment($commentId)
  {
    return $this->createQuery()
            ->delete()
            ->where('id = ?', $commentId)
            ->execute();
  }
  
  public function approveComment($commentId)
  {
    $this->createQuery()
            ->update()
            ->set('display', 1)
            ->where('id = ?', $commentId)
            ->execute();
  }

}