<?php

/**
 * PluginArticlePhoto
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @package    ##PACKAGE##
 * @subpackage ##SUBPACKAGE##
 * @author     ##NAME## <##EMAIL##>
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class PluginArticlePhoto extends BaseArticlePhoto
{
  protected $_path = '/uploads/articles/%id%/';
  /**
   * Funkcja sprawdza czy obiekt ma juz ustawiony original_image
   * @return boolean 
   */
  public function hasOriginalImage() {
    if ($this->getOriginalImage() != '') {
      return true;
    }
    
    return false;
  }
  
  /**
   * Zwraca sciezke do obrazka lub placeholder
   * @return string
   */
  public function getSmallImageSrc() {
    $image = $this->getSmallImage();
    if ($image && is_file($this->getImageAbsolutePath('small'))) {
      return $this->getImagePath('small');
    } else {
      $width = $this->getArticle()->getParam('img_small_width', 1920);
      $height = $this->getArticle()->getParam('img_small_height', 1080);
      return sfContext::getInstance()->getRouting()->generate('placehold') . '?' . $width . '-' . $height . '-CCCCCC-969696&text=Brak zdjęcia';
    }
  }

  /**
   * Zwraca sciezke do obrazka lub placeholder
   * @return string
   */
  public function getMediumImageSrc() {
    $image = $this->getMediumImage();
    if ($image && is_file($this->getImageAbsolutePath('medium'))) {
      return $this->getImagePath('medium');
    } else {
      $width = $this->getArticle()->getParam('img_medium_width', 1920);
      $height = $this->getArticle()->getParam('img_medium_height', 1080);
      return sfContext::getInstance()->getRouting()->generate('placehold') . '?' . $width . '-' . $height . '-CCCCCC-969696&text=Brak zdjęcia';
    }
  }
  
  /**
   * Zwraca sciezke do obrazka lub placeholder
   * @return string
   */
  public function getBigImageSrc() {
    $image = $this->getSmallImage();
    if ($image && is_file($this->getImageAbsolutePath('big'))) {
      return $this->getImagePath('big');
    } else {
      $width = $this->getArticle()->getArticlePhotoBigImageWidth();
      $height = $this->getArticle()->getArticlePhotoBigImageHeight();
      return sfContext::getInstance()->getRouting()->generate('placehold') . '?' . $width . '-' . $height . '-CCCCCC-969696&text=Brak zdjęcia';
    }
  }
  
  /**
   * Zwraca sciezke do obrazka lub placeholder
   * @return string
   */
  public function getOriginalImageSrc() {
    $image = $this->getOriginalImage();
    if ($image && is_file($this->getImageAbsolutePath('original'))) {
      return $this->getImagePath('original');
    } else {
      $width = $this->getArticle()->getParam('img_original_width', 1920);
      $height = $this->getArticle()->getParam('img_original_height', 1080);
      return sfContext::getInstance()->getRouting()->generate('placehold') . '?' . $width . '-' . $height . '-CCCCCC-969696&text=Brak zdjęcia';
    }
  }

  /**
   * Metoda zwraca ścieżkę do pliku obrazka rozpoczynając od root http czyli / oznacza ...site/web
   * @param string $imageSize - rozmiar obrazka small, medium, big, original
   * @return string ImagePath 
   */
  public function getImagePath($imageSize)
  {
    $path = str_replace('%id%', $this->getArticleId() , $this->_path);
    $photo = $this->__get($imageSize . '_image');
    
    return $path . $imageSize . '/' . $photo;
  }
  
  /**
   * Metoda zwraca ścieżkę do pliku obrazka rozpoczynając od root http czyli / oznacza ...site/web
   * @param string $imageSize - rozmiar obrazka small, medium, big, original
   * @return string ImageDir
   */
  public function getImageDir($imageSize)
  {
    $path = str_replace('%id%', $this->getArticleId() , $this->_path);
    return $path . $imageSize . '/';
  }
  
  /**
   * Metoda zwraca absolutną ścieżkę do pliku obrazka na serwerze czyli / oznacza / na dysku
   * @param string $imageSize - rozmiar obrazka small, medium, big, original
   * @return string ImageAbsolutePath 
   */
  public function getImageAbsolutePath($imageSize)
  {
    return sfConfig::get('sf_web_dir') . $this->getImagePath($imageSize);
  }
  
  /**
   * Metoda zwraca absolutną ścieżkę do pliku obrazka na serwerze czyli / oznacza / na dysku
   * @param string $imageSize - rozmiar obrazka small, medium, big, original
   * @return string ImageAbsoluteDir
   */
  public function getImageAbsoluteDir($imageSize)
  {
    return sfConfig::get('sf_web_dir') . $this->getImageDir($imageSize);
  }
  
  public function postDelete($event)
  {
    Doctrine::getTable('ArticlePhoto')->repairOrders($this->getArticleId());
      }
}