<?php

/**
 * PluginArticleTable
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 */
class PluginArticleTable extends artDoctrineTable {

  /**
   * Returns an instance of this class.
   *
   * @return object PluginArticleTable
   */
  public static function getInstance() {
    return Doctrine_Core::getTable('PluginArticle');
  }

  public function getArticlesWithoutOne($articleId = null) {
    $culture = $this->getUserCulture();

    if (is_null($articleId))
      $articleId = $this->getRequest()->getParameter('id');

    return $this->createQuery('a')
            ->leftJoin("a.Translation at WITH at.lang='$culture'")
            ->where('a.id <> ?', $articleId);
  }

  public function getTranslationList() {
    $culture = $this->getUserCulture();

    return $this->createQuery('a')
            ->leftJoin("a.Translation at WITH at.lang='$culture'");
  }

  public static function getArticleObject($options) {
    $articleId = $options['id'];

    $query = Doctrine::getTable('Article')
        ->createQuery('a')
        ->leftJoin('a.Translation at')
        ->leftJoin('a.Categories c')
        ->where('a.id = ?', $articleId);

    $query->leftJoin('a.Groups g')
        ->leftJoin('a.Permissions p');

    $query->leftJoin('a.Tags t');

    return $query->fetchOne();
  }

  public function getArticleSearchCount($searchPhrase) {
    $query = $this->getTranslationList();
    $query = $this->addSearchPhraseColumnQuery($query, $searchPhrase);
    return $query->count();
  }

  public function getArticleSearch($searchPhrase, $limit = 10, $offset = 0) {
    $query = $this->getTranslationList();
    $query = $this->addSearchPhraseColumnQuery($query, $searchPhrase);
    $query->limit($limit)
        ->offset($offset);
    return $query->execute();
  }

  public function addSearchPhraseColumnQuery(Doctrine_Query $query, $searchPhrase) {
    $rootAlias = $query->getRootAlias();
    sfProjectConfiguration::getActive()->loadHelpers(array('I18N'));
    if ($searchPhrase == '' || $searchPhrase == __('Search'))
      return $query;

    $ids = artSphinxSearch::search('*' . $searchPhrase . '*', sfConfig::get('app_sphinx_article_search_indexes'));
    if (empty($ids))
      return $query->andWhere('1 = 0');
    else
      return $query->andWhereIn($rootAlias . '.id', $ids);
  }

  public function getBackendList(Doctrine_Query $query) {
    $rootAlias = $query->getRootAlias();
    $userLang = $this->getUserCulture();

    $query->leftJoin("$rootAlias.Translation at WITH at.lang='$userLang'");
    $query->leftJoin($rootAlias . '.sfGuardUser sfgu');
    $query->leftJoin($rootAlias . '.Layout l');

    return $query;
  }

  public function getBackendBlogList(Doctrine_Query $query) {
    $categoriesIds = Doctrine::getTable('Category')->getBlogList()->execute(array(), Doctrine::HYDRATE_SINGLE_SCALAR);
    $categoriesIds[] = Doctrine::getTable('Category')->getBlogId();
    $rootAlias = $query->getRootAlias();

    return $query
            ->leftJoinTranslation($rootAlias)
            ->leftJoin($rootAlias . '.sfGuardUser sfgu')
            ->leftJoin($rootAlias . '.articleCategories ac')
            ->whereIn('ac.category_id', $categoriesIds);
  }

  public function getNews(Doctrine_Query $query, $newsCategory = null) {
    $rootAlias = $query->getRootAlias();
    $userLang = $this->getUserCulture();

    if (is_null($newsCategory))
      $newsCategory = $this->getRequest()->getParameter('category', 'news');

    $query->leftJoin("$rootAlias.Translation at WITH at.lang='$userLang'")
        ->leftJoin($rootAlias . '.sfGuardUser sfgu')
        ->leftJoin($rootAlias . '.Layout l')
        ->leftJoin($rootAlias . '.Categories c')
        ->where('c.unique_name = ?', $newsCategory);

    return $query;
  }

  public function getNewsFromCategory($newsCategory) {
    return $this->getNews($this->createQuery('a'), $newsCategory)->execute();
  }

  public function getArticleBySlug($slug, $lang = true) {
    $userLang = $this->getUserCulture();

    $query = $this->createQuery('a')
        ->leftJoin("a.Translation at WITH at.lang='$userLang'")
        ->leftJoin('a.Layout l')
        ->leftJoin('a.Categories c')
        ->leftJoin("c.Translation ct WITH ct.lang='$userLang'")
        ->leftJoin('a.Permissions p')
        ->where('at.slug = ?', $slug);

    return $query->fetchOne();
  }

  public function getArticleBySlugWithPhotos($slug) {
    $userLang = $this->getUserCulture();

    $query = $this->createQuery('a')
        ->leftJoin("a.Translation at WITH at.lang='$userLang'")
        ->leftJoin('a.Layout l')
        ->leftJoin('a.Categories c')
        ->leftJoin("c.Translation ct WITH ct.lang='$userLang'")
        ->leftJoin('a.Permissions p')
        ->leftJoin('a.articlePhotoes ap')
        ->leftJoinTranslation('ap')
        ->where('at.slug = ?', $slug)
        ->orderBy('ap.order ASC');

    $query->leftJoin('a.Tags t')
        ->leftJoin("t.Translation tt WITH tt.lang='$userLang'");

    return $query->fetchOne();
  }

  public function getArticleDataByUniqueName($uName) {
    $userLang = $this->getUserCulture();

    $query = $this->createQuery('a')
        ->leftJoin("a.Translation at WITH at.lang='$userLang'")
        ->leftJoin('a.Layout l')
        ->leftJoin('a.Categories c')
        ->leftJoin("c.Translation ct WITH ct.lang='$userLang'")
        ->leftJoin('a.Permissions p')
        ->where('a.unique_name = ?', $uName);

    $query->leftJoin('a.Tags t')
        ->leftJoin("t.Translation tt WITH tt.lang='$userLang'");

    return $query->fetchOne();
  }

  /**
   * Pobiera Artykul do kopiowania przy tworzeniu nowego Artykulu 
   * przez FrontendManagement (a dokladnie ArticleForm lub MenuItemArticleForm).
   * 
   * @param string $uniqueName Unikalna nazwa artykulu
   * @return Article Obiekt artykułu
   */
  public function getArticleDataForCopy($uniqueName) {
    // WARNING: Pamietac ze jak dodajemy nowe relacje trzeba je uwzglednic w
    // funkcji kopiujacej. PluginArticle->copyFromArray();
    return $this->createQuery('a')
            ->leftJoin('a.Translation at')
            ->leftJoin('a.articlePhotoes ap')
            ->leftJoin('ap.Translation apt')
            ->leftJoin('a.articleCategories ac')
            ->where('a.unique_name = ?', $uniqueName)
            ->fetchOne(array(), Doctrine::HYDRATE_ARRAY);
  }

  public function getArticleById($id) {
    return $this->createQuery('a')
            ->leftJoinTranslation('a')
            ->leftJoin('a.Layout l')
            ->leftJoin('a.Categories c')
            ->leftJoin('c')
            ->where('a.id = ?', $id)
            ->fetchOne();
  }

  public function getIdBySlug($slug) {
    $query = $this->createQuery('a')
        ->leftJoin('a.Translation at')
        ->where('at.slug = ?', $slug)
        ->fetchOne();

    return $query ? $query->getId() : false;
  }

  public function getSlugById($id) {
    $userLang = $this->getUserCulture();

    $query = $this->createQuery('a')
        ->where('a.id = ?', $id)
        ->leftJoin("a.Translation at WITH at.lang='$userLang'")
        ->fetchOne();

    return $query ? $query->getSlug() : false;
  }

  public function getOtherCultureSlugBySlug($slug) {
    $id = $this->getIdBySlug($slug);
    $slug = $this->getSlugById($id);

    return $slug;
  }

  public function getDisplayArticleBySlug($slug) {
    $userLang = $this->getUserCulture();

    $query = $this->createQuery('a')
        ->leftJoin("a.Translation at WITH at.lang='$userLang'")
        ->leftJoin('a.Layout l')
        ->leftJoin('a.Categories c')
        ->leftJoin("c.Translation ct WITH ct.lang='$userLang'")
        ->where('at.slug = ?', $slug)
        ->andWhere('a.is_displayed = ?', 1);

    $query->leftJoin('a.Tags t')
        ->leftJoin("t.Translation tt WITH tt.lang='$userLang'");

    return $query->fetchOne();
  }

  public function getArticleByUniqueName($uName) {
    return $this->createQuery('a')
            ->leftJoinTranslation('a')
            ->leftJoin('a.Layout l')
            ->where('a.unique_name = ?', $uName)
            ->fetchOne();
  }

  public function getArticleByUniqueNameWithPhotos($uName) {
    return $this->createQuery('a')
            ->leftJoinTranslation('a')
            ->leftJoin('a.Layout l')
            ->leftJoin('a.articlePhotoes ap')
            ->leftJoinTranslation('ap')
            ->where('a.unique_name = ?', $uName)
            ->orderBy('ap.order ASC')
            ->fetchOne();
  }

  public function getArticleOfCategoryCountById($categoryId, $createdAtLessThanNow = false, $createdAt = null) {

    $q = $this->createQuery('a')
        ->leftJoin('a.Categories c')
        ->leftJoinTranslation('a')
        ->leftJoin('a.articleCategories ac')
        ->where('c.id = ?', $categoryId)
        ->andWhere('a.is_displayed = ?', 1);

    if ($createdAtLessThanNow)
      $q->andWhere('a.created_at <= NOW()');

    if ($createdAt != null)
      $q->andWhere('DATE(a.created_at) = ?', $createdAt);


    return $q->count();
  }

  public function getArticleByCategoryId($categoryId, $limit = 20, $offset = 0, $orderAsc = true, $orderCreatedAtDesc = false, $createdAtLessThanNow = false, $createdAt = null, $isDisplayed = 1, $withPhotos = true, $withLayout = true) {

    $q = $this->createQuery('a')
        ->leftJoin('a.Categories c')
        ->leftJoinTranslation('a')
        ->leftJoin('a.articleCategories ac')
        ->andWhere('a.is_displayed = ?', 1)
        ->limit($limit)
        ->offset($offset);

    if (is_array($categoryId)) {
      $q->whereIn('c.id', $categoryId);
    } else {
      $q->where('c.id = ?', $categoryId);
    }

    $q->andWhere('a.is_displayed = ?', $isDisplayed);

    if ($createdAtLessThanNow) {
      $q->andWhere('a.created_at <= NOW()');
    }

    if ($createdAt != null) {
      $q->andWhere('date(a.created_at) = ?', $createdAt);
    }
    
    if ($withPhotos) {
      $q->leftJoin('a.articlePhotoes ap');
      $q->leftJoin('ap.Translation apt');
    }
    
    if ($withLayout) {
      $q->leftJoin('a.Layout l');
    }

    if ($orderAsc)
      $q->addOrderBy('ac.order ASC');

    if ($orderCreatedAtDesc)
      $q->addOrderBy('a.created_at DESC');

    return $q->execute();
  }

  public function getArticleOfCategoryById($categoryId, $limit = 20, $offset = 0, $orderAsc = true, $orderCreatedAtDesc = false, $createdAtLessThanNow = false, $createdAt = null, $isDisplayed = 1) {

    $q = $this->createQuery('a')
        ->leftJoin('a.Categories c')
        ->leftJoinTranslation('a')
        ->leftJoin('a.articleCategories ac')
        ->andWhere('a.is_displayed = ?', 1)
        ->limit($limit)
        ->offset($offset);

    if (is_array($categoryId)) {
      $q->whereIn('c.id', $categoryId);
    } else {
      $q->where('c.id = ?', $categoryId);
    }

    $q->andWhere('a.is_displayed = ?', $isDisplayed);

    if ($createdAtLessThanNow)
      $q->andWhere('a.created_at <= NOW()');

    if ($createdAt != null)
      $q->andWhere('date(a.created_at) = ?', $createdAt);

    if ($orderAsc)
      $q->addOrderBy('ac.order ASC');

    if ($orderCreatedAtDesc)
      $q->addOrderBy('a.created_at DESC');

    return $q->execute();
  }

  public function getArticleOfCategory($categoryUniqueName, $limit = 20, $offset = 0, $orderAsc = true, $orderCreatedAtDesc = false, $createdAtLessThanNow = false, $createdAt = null) {
//$ttt = explode('*', $categoryUniqueName);
    if (strpos($categoryUniqueName, '*') !== false) {

      $categoryUniquesNames = explode('*', $categoryUniqueName);
      $categoryIdsArrayRepack = array();
      $categoryUNameForGetIds = array();

      foreach ($categoryUniquesNames as $categoryUniqueName) {

        if (substr($categoryUniqueName, 0, 1) == "/") {

          if (substr($categoryUniqueName, -1) != "/")
            $categoryUniqueName .= "/";

          $categoryUniqueName = substr($categoryUniqueName, 1);

          artQuery::executeSql("call get_category_ids_from_tree ('$categoryUniqueName')");

          $categoryIdsArray = Doctrine_Manager::getInstance()->connection()
              ->fetchAll('SELECT id FROM search_category_result');

          foreach ($categoryIdsArray as $categoryId) {
            array_push($categoryIdsArrayRepack, $categoryId['id']);
          }
        } else {

          array_push($categoryUNameForGetIds, $categoryUniqueName);
        }
      }


      if (count($categoryUNameForGetIds) != 0) {

        $categorysObj = Doctrine::getTable('Category')->createQuery('cat')
            ->whereIn('cat.unique_name', $categoryUNameForGetIds)
            ->execute();

        foreach ($categorysObj as $category) {
          array_push($categoryIdsArrayRepack, $category->getId());
        }
      }


      $q = $this->createQuery('a')
          ->leftJoin('a.Categories c')
          ->leftJoinTranslation('a')
          ->leftJoin('a.articleCategories ac')
          ->whereIn('c.id', $categoryIdsArrayRepack)
          ->andWhere('a.is_displayed = ?', 1)
          ->limit($limit)
          ->offset($offset);

      if (count($categoryIdsArrayRepack) == 0)
        $q->andWhere('1 = 0');
    }else {

      if (substr($categoryUniqueName, 0, 1) == "/") {

        if (substr($categoryUniqueName, -1) != "/")
          $categoryUniqueName .= "/";

        $categoryUniqueName = substr($categoryUniqueName, 1);

        artQuery::executeSql("call get_category_ids_from_tree ('$categoryUniqueName')");

        $categoryIdsArray = Doctrine_Manager::getInstance()->connection()
            ->fetchAll('SELECT id FROM search_category_result');

        $categoryIdsArrayRepack = array();

        foreach ($categoryIdsArray as $categoryId) {
          array_push($categoryIdsArrayRepack, $categoryId['id']);
        }


        $q = $this->createQuery('a')
            ->leftJoin('a.Categories c')
            ->leftJoinTranslation('a')
            ->leftJoin('a.articleCategories ac')
            ->whereIn('c.id', $categoryIdsArrayRepack)
            ->andWhere('a.is_displayed = ?', 1)
            ->limit($limit)
            ->offset($offset);

        if (count($categoryIdsArrayRepack) == 0)
          $q->andWhere('1 = 0');
      }else {
        $q = $this->createQuery('a')
            ->leftJoin('a.Categories c')
            ->leftJoinTranslation('a')
            ->leftJoin('a.Layout l')
            ->leftJoin('a.articleCategories ac')
            ->leftJoin('c.Translation ct')
            ->where('c.unique_name = ?', $categoryUniqueName)
            ->andWhere('a.is_displayed = ?', 1)
            ->limit($limit)
            ->offset($offset);
      }
    }

    if ($createdAtLessThanNow)
      $q->andWhere('a.created_at <= NOW()');

    if ($createdAt != null)
      $q->andWhere('date(a.created_at) = ?', $createdAt);

    if ($orderAsc)
      $q->addOrderBy('ac.order ASC');

    if ($orderCreatedAtDesc)
      $q->addOrderBy('a.created_at DESC');

    return $q->execute();
  }

  public function getDatesOfArticle($categoryUniqueName, $orderCreatedAtDesc = false, $createdAtLessThanNow = false, $createdAt = null) {
    if (strpos($categoryUniqueName, '*') !== false) {
      $categoryUniquesNames = explode('*', $categoryUniqueName);
      $arr = array();
      foreach ($categoryUniquesNames as $cun) {
        $arr = array_merge($arr, $this->getDatesofArticle($cun, $orderCreatedAtDesc, $createdAtLessThanNow, $createdAt));
      }
      return $arr;
    }

    if (substr($categoryUniqueName, 0, 1) == "/") {
      if (substr($categoryUniqueName, -1) != "/")
        $categoryUniqueName .= "/";

      $categoryUniqueName = substr($categoryUniqueName, 1);

      artQuery::executeSql("call get_category_ids_from_tree ('$categoryUniqueName')");

      $categoryIdsArray = Doctrine_Manager::getInstance()->connection()
          ->fetchAll('SELECT id FROM search_category_result');

      $categoryIdsArrayRepack = array();

      foreach ($categoryIdsArray as $categoryId) {
        array_push($categoryIdsArrayRepack, $categoryId['id']);
      }

      $q = $this->createQuery('a')
          ->leftJoin('a.Categories c')
          ->leftJoinTranslation('a')
          ->leftJoin('a.articleCategories ac')
          ->whereIn('c.id', $categoryIdsArrayRepack)
          ->andWhere('a.is_displayed = ?', 1)
          ->groupBy('DATE(a.created_at)');

      if (count($categoryIdsArrayRepack) == 0)
        $q->andWhere('1 = 0');
    }
    else {
      $q = $this->createQuery('a')
          ->select('a.id, a.created_at')
          ->leftJoin('a.Categories c')
          ->where('c.unique_name = ?', $categoryUniqueName)
          ->andWhere('a.is_displayed = ?', 1)
          ->groupBy('DATE(a.created_at)');
    }

    $array = $q->fetchArray();
    $valueArray = array();

    foreach ($array as $arrays) {
      array_push($valueArray, $arrays['created_at']);
    }


    return $valueArray;
  }

  public function getArticleOfCategoryCount($categoryUniqueName, $createdAtLessThanNow = false, $createdAt = null) {
    if (strpos($categoryUniqueName, '*') !== false) {
      $categoryUniquesNames = explode('*', $categoryUniqueName);
      $count = 0;
      foreach ($categoryUniquesNames as $cun) {
        $count = $count + $this->getArticleOfCategoryCount($cun, $createdAtLessThanNow, $createdAt);
      }
      return $count;
    }

    if (substr($categoryUniqueName, 0, 1) == "/") {

      if (substr($categoryUniqueName, -1) != "/")
        $categoryUniqueName .= "/";

      $categoryUniqueName = substr($categoryUniqueName, 1);

      artQuery::executeSql("call get_category_ids_from_tree ('$categoryUniqueName')");

      $categoryIdsArray = Doctrine_Manager::getInstance()->connection()
          ->fetchAll('SELECT id FROM search_category_result');

      $categoryIdsArrayRepack = array();

      foreach ($categoryIdsArray as $categoryId) {
        array_push($categoryIdsArrayRepack, $categoryId['id']);
      }

      $q = $this->createQuery('a')
          ->leftJoin('a.Categories c')
          ->leftJoinTranslation('a')
          ->leftJoin('a.articleCategories ac')
          ->whereIn('c.id', $categoryIdsArrayRepack)
          ->andWhere('a.is_displayed = ?', 1);

      if (count($categoryIdsArrayRepack) == 0)
        $q->andWhere('1 = 0');
    }else {

      $q = $this->createQuery('a')
          ->leftJoin('a.Categories c')
          ->leftJoinTranslation('a')
          ->leftJoin('a.articleCategories ac')
          ->where('c.unique_name = ?', $categoryUniqueName)
          ->andWhere('a.is_displayed = ?', 1);
    }

    if ($createdAtLessThanNow)
      $q->andWhere('a.created_at <= NOW()');

    if ($createdAt != null)
      $q->andWhere('DATE(a.created_at) = ?', $createdAt);


    return $q->count();
  }

  public function getArticleCategoryAndPage($slug, $category) {
    //page
    //category
    $returnArray = array();

    $userLang = $this->getUserCulture();

    $subcategories = Doctrine::getTable('ArticleCategory')->getSubcategory($category);
    $subcategories_ids = array();

    foreach ($subcategories as $subcat)
      $subcategories_ids[] = $subcat->getSubcategoryId();


    $category_data = $this->createQuery('a')
        ->select('c.unique_name, c.image_count, a.id')
        ->leftJoin("a.Translation at WITH at.lang='$userLang'")
        ->leftJoin('a.Categories c')
        ->where('at.slug = ?', $slug)
        ->andWhereIn('c.id', $subcategories_ids)
        ->fetchArray();
    if (count($category_data) > 0) {
      $unique_name = $category_data[0]['Categories'][0]['unique_name'];
      $image_count = $category_data[0]['Categories'][0]['image_count'];


      $rank_return = SqlRaw::execute("select article_flash_get_position('$unique_name','$slug','$userLang');");

      $rank = $rank_return[0][0];

      $returnArray['category'] = $unique_name;
      $returnArray['page'] = floor($rank / $image_count);
    }
    return $returnArray;
  }

  public function getArticleBySlugWithDetails($slug) {
    $userLang = $this->getUserCulture();

    $query = $this->createQuery('a')
        ->leftJoin('a.articleArticleDetails aad')
        ->leftJoinTranslation('aad')
        ->leftJoin('aad.ArticleDetail ad')
        ->leftJoinTranslation('ad')
        ->leftJoin("a.Translation at WITH at.lang='$userLang'")
        ->leftJoin('a.Layout l')
        ->leftJoin('a.Categories c')
        ->leftJoin("c.Translation ct WITH ct.lang='$userLang'")
        ->where('at.slug = ?', $slug);

    $query->leftJoin('a.Tags t')
        ->leftJoin("t.Translation tt WITH tt.lang='$userLang'");

    return $query->fetchOne();
  }

  public function getArticlesForBlog(Doctrine_Query $query) {
    $rootAlias = $query->getRootAlias();

    $articlesIds = Doctrine::getTable('ArticleArticleBlogCategory')->getArticlesIds();

    $query->leftJoinTranslation($rootAlias);
    $query->leftJoin($rootAlias . '.ArticleBlogCategories abc');
    $query->andWhereIn($rootAlias . '.id', $articlesIds);
    $query->andWhere($rootAlias . '.is_displayed = ?', 1);
    $query->orderBy($rootAlias . '.created_at DESC');

    return $query;
  }

  public function getLastArticlesForBlog($limit) {
    $articlesIds = Doctrine::getTable('ArticleArticleBlogCategory')->getArticlesIds();

    return $this->createQuery('a')
            ->leftJoinTranslation('a')
            ->andWhereIn('a.id', $articlesIds)
            ->andWhere('a.is_displayed = ?', 1)
            ->orderBy('a.created_at DESC')
            ->limit($limit)
            ->execute();
  }

  /** MenuDataCollector * */

  /**
   * Funkcja pobiera artykuly wykorzystujac przekazana tablice ID.
   * 
   * @return array
   */
  public function getArticlesByIds($articleIds, $culture) {
    return $this->createQuery('a')
            ->select('a.id, a.unique_name, at.title, at.slug')
            ->leftJoin('a.Translation at')
            ->where('at.lang = ?', $culture)
            ->andWhereIn('a.id', $articleIds)
            ->execute();
  }

  /** KONIEC - MenuDataCollector * */
  /** MenuItemArticleForm * */

  /**
   * Funkcja pobiera artykuly i konwertuje ja do tablicy ktora moze byc wykorzystana przez widget.
   * 
   * @param string $culture
   * @param boolean $addNewChoice Czy dodac pozycje dodania nowego artykulu
   * @return array
   */
  public function getArticlesForMenuItem($culture, $addNewChoice = false) {
    $articles = $this->createQuery('a')
        ->select('a.id, at.title')
        ->leftJoin('a.Translation at')
        ->where('a.is_displayed = ?', 1)
        ->andWhere('at.lang = ?', $culture)
        ->fetchArray();

    $articlesArray = array();
    if ($addNewChoice) {
      $articlesArray[] = '-- Nowy Artykuł --';
    }
    foreach ($articles as $article) {
      $articlesArray[$article['id']] = $article['Translation'][$culture]['title'];
    }

    return $articlesArray;
  }

  /** KONIEC - MenuItemArticleForm * */
  /**
   * artSitemapTask
    
   */

  /**
   * Pobiera wszystkie artykuly z bazy za wyjatkiem tych ktore maja
   * ustawione is_displayed = 0
   * @return array Tablica artykulow
   */
  public function getArticles($culture = false) {

    $query = $this->createQuery('a');

    if ($culture) {
      $query->leftJoin('a.Translation at')->where('at.lang = ?', $culture)->andWhere('a.is_displayed = ?', 1);
    } else {
      $query->leftJoin('a.Translation at')->where('a.is_displayed = ?', 1);
    }

    return $query->execute();
  }

  /**
   * Pobiera artykuly z bazy nalezace do kategorii o podanym $uniqueName
   * za wyjatkiem tych ktore maja ustawione is_displayed = 0
   * @param string $uniqueName unique_name kategorii
   * @return array Tablica artykulow
   */
  public function getArticlesFromCategory($uniqueName) {
    $data = Doctrine::getTable('Category')
        ->createQuery('c')
        ->select('c.id, a.id')
        ->leftJoin('c.Articles a')
        ->where('c.unique_name = ?', $uniqueName)
        ->fetchOne(array(), Doctrine::HYDRATE_ARRAY);

    $articleIds = array();

    foreach ($data['Articles'] as $record) {
      $articleIds[] = $record['id'];
    }

    if (count($articleIds) == 0) {
      return array();
    } else {
      return $this->createQuery('a')
              ->leftJoin('a.Translation at')
              ->where('a.is_displayed = ?', 1)
              ->andWhereIn('a.id', $articleIds)
              ->fetchArray();
    }
  }

  /** KONIEC - artSitemapTask */
}
