<?php

/**
 * PluginCategory
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @package    ##PACKAGE##
 * @subpackage ##SUBPACKAGE##
 * @author     ##NAME## <##EMAIL##>
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class PluginCategory extends BaseCategory {

  /**
   * Parametry Layoutu przypisanego do kategorii. 
   * 
   * @var type 
   */
  public $layoutParams = array();

  /**
   * Konstruktor
   */
  public function construct() {
    parent::construct();

    $this->getLayoutParams();
  }

  /**
   * Pobiera parametry i zapisuje do array w obiekcie. 
   */
  public function getLayoutParams() {

    foreach ($this->getLayout()->getLayoutParams() as $key => $param) {

      $this->layoutParams[$param->getName()] = $param->getValue();
    }
  }

  /**
   * Sprawdza czy paramer jest ustawionny. 
   * 
   * @param type $name
   * @return type
   */
  public function hasParam($name) {

    return isset($this->layoutParams[$name]) ? $this->layoutParams[$name] : false;
  }

  /**
   * Zwraca value parametu. 
   * 
   * @param type $name
   * @param type $default
   * @return type
   */
  public function getParam($name, $default = null) {

    return (isset($this->layoutParams[$name]) && $this->layoutParams[$name] != '') ? $this->layoutParams[$name] : $default;
  }

  /**
   * Zwraca link do kategorii.
   * 
   * @param type $params
   * @return boolean
   */
  public function getUrl($params = array()) {

    if ($this->getIsDisplayed()) {
      $context = sfContext::getInstance();

      if (!isset($params['slug'])) {
        $params['slug'] = $this->getSlug();
      }

      return $context->getRouting()->generate('redirector', $params);
    } else {
      return false;
    }
  }

  public function getDescriptionHtml() {

    echo htmlspecialchars_decode(parent::getDescription());
  }

  public function getTitle() {

    return strip_tags(htmlspecialchars_decode(parent::getName()));
  }

  public function hasTitle() {
    return $this->hasParam('title');
  }

  public function hasBreadcrumbs() {
    return $this->hasParam('breadcrumbs');
  }

  public function hasDescription() {
    return $this->hasParam('description');
  }

  public function hasBigImage() {
    return $this->hasParam('big_image');
  }

  public function hasVideo() {
    return $this->hasParam('video');
  }

  public function hasShortDescription() {
    return $this->hasParam('short_description');
  }

  public function hasMoreLink() {
    return $this->hasParam('more_link');
  }

  public function hasLinks() {
    return $this->hasParam('links');
  }

  public function hasArticleTitle() {
    return $this->hasParam('article_title');
  }

  public function hasArticleMeta() {
    return $this->hasParam('article_meta');
  }

  public function hasTitleImage() {
    $titleImage = $this->getTitleImage();

    return isset($titleImage) && $titleImage != '';
  }

  public static function getTitleImagePath() {
    return '/uploads/' . sfConfig::get('app_category_title_image_path', 'category/');
  }

  public function hasHeaderOnTop() {
    return $this->hasParam('header_on_top');
  }

  public static function getTitleImageAbsolutePath() {
    return sfConfig::get('sf_upload_dir') . '/' . sfConfig::get('app_category_title_image_path', 'category/');
  }

  public function canBeDeleted() {
    return true;
  }

  /**
   * Zwaca liczbe artykulow w kategorii
   * @param string $categoryUniqueName 
   */
  public function getArticleCount() {
    return Doctrine::getTable('ArticleCategory')
                    ->createQuery('aac')
                    ->where('aac.category_id = ?', $this->getId())
                    ->andWhere('aac.article_id  IS NOT NULL')
                    ->andWhere('aac.subcategory_id IS NULL')
                    ->count();
  }

  protected function recursiveUnset(&$array, $unwanted_key) {
    unset($array[$unwanted_key]);
    foreach ($array as &$value) {
      if (is_array($value)) {
        $this->recursiveUnset($value, $unwanted_key);
      }
    }
  }

  /**
   * Funkcja uzupelnia NOWY obiekt wykorzystujac podana tablice.
   * Napisana ze wzgledu na to ze funkcja copy() ma wyciek pamieci przy wielu relacjach
   * @param array $data
   */
  public function copyFromArray(array $data) {
    // Usuwamy wszystkie wpisy w tablicach z ID bo chcemy miec obiekty z nowymi ID
    $this->recursiveUnset($data, 'id');
    foreach ($data['Translation'] as $culture => &$record) {
      $record['slug'] = md5($this->getTitle() . '-' . rand(10, 1000) . '-' . rand(1000, 123123));
    }
    $this->fromArray($data);
    $this->setUniqueName(NULL);

    $this->save();
  }

  public function preDelete($con = null) {

    $objects = Doctrine::getTable('MenuItem')->createQuery('mi')
//                ->delete('MenuItem mi')
                    ->whereIn('mi.url_type', array(GroupMenu::URL_CATEGORY, GroupMenu::URL_CATEGORY_TITLE))
                    ->leftJoin('mi.Translation mit')
                    ->andWhere('mit.url = ?', $this->getId())->execute();

    foreach ($objects as $object) {
      $object->delete();
    }


    $this->clearCache();
    parent::preDelete($con);
  }

  public function postSave($con = null) {

    $this->clearCache();
    parent::postSave($con);
  }

  public function clearCache() {

    $cacheDir = sfConfig::get('sf_cache_dir') . '/';
    $cache = new sfFileCache(array('cache_dir' => $cacheDir));
    $cache->clean();
  }

}
