<?php

/**
 * PluginCategoryTable
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 */
class PluginCategoryTable extends artDoctrineTable {


  /**
   * Returns an instance of this class.
   *
   * @return object PluginCategoryTable
   */
  public static function getInstance() {
    return Doctrine_Core::getTable('PluginCategory');
  }


  public function getTranslationList() {
    $culture = $this->getUserCulture();

    return $this->createQuery('c')
                    ->leftJoin("c.Translation ct WITH ct.lang='$culture'");
  }

  public function getSubcategoriesList() {
    $culture = $this->getUserCulture();
    $categoryId = $this->getRequest()->getParameter('id');

    return $this->createQuery('c')
                    ->leftJoin("c.Translation ct WITH ct.lang='$culture'")
                    ->where('c.id <> ?', $categoryId);
  }

  public static function getCategoryObject($options) {
    $categoryId = $options['id'];

    return Doctrine::getTable('Category')
                    ->createQuery('c')
                    ->leftJoin('c.Translation ct')
                    ->leftJoin('c.Subcategories s')
                    ->leftJoin('c.Articles a')
                    ->where('c.id = ?', $categoryId)
                    ->fetchOne();
  }

  public function getBackendList(Doctrine_Query $query) {
    $rootAlias = $query->getRootAlias();
    $userLang = $this->getUserCulture();

    $query->leftJoin("$rootAlias.Translation ct WITH ct.lang='$userLang'");

    return $query;
  }

  /**
   * Obiekt po unikalnej nazwie. 
   * 
   * @param type $uniqueName
   * @return type
   */
  public function getByUniqueName($uniqueName) {
    
    return $this->createQuery('c')
                    ->leftJoinTranslation('c')
                    ->where('c.unique_name = ?', $uniqueName)
                    ->fetchOne();
  }

  /**
   * Obiekt po Slagu. 
   * 
   * @param type $slug
   * @return type
   */
  public function getBySlug($slug) {
    return $this->createQuery('c')
                    ->leftJoinTranslation('c')
                    ->where('ctrans.slug = ?', $slug)
                    ->fetchOne();
  }

  /**
   * Id obiektu po slugu. 
   * 
   * @param type $slug
   * @return type
   */
  public function getIdBySlug($slug) {
    
    $query = $this->createQuery('c')
            ->leftJoin('c.Translation ct')
            ->where('ct.slug = ?', $slug)
            ->fetchOne();

    return $query ? $query->getId() : false;
  }

  /**
   * Slug obiektu po ID.
   * 
   * @param type $id
   * @return type
   */
  public function getSlugById($id) {
    $userLang = $this->getUserCulture();

    $query = $this->createQuery('c')
            ->where('c.id = ?', $id)
            ->leftJoin("c.Translation ct WITH ct.lang='$userLang'")
            ->fetchOne();

    return $query ? $query->getSlug() : false;
  }

  /**
   * Slug z innej wersji językowej.
   * 
   * @param type $slug
   * @return type
   */
  public function getOtherCultureSlugBySlug($slug) {
    $id = $this->getIdBySlug($slug);
    $slug = $this->getSlugById($id);

    return $slug;
  }

  /**
   * Obiekty po unikalnych nazwach. 
   * 
   * @param type $uniqueNames
   * @return type
   */
  public function getByUniqueNames($uniqueNames = array()) {
    return $this->createQuery('c')
                    ->leftJoinTranslation('c')
                    ->whereIn('c.unique_name', $uniqueNames)
                    ->execute();
  }

  public function getIdsByUniqueNames($uniqueNames = array()) {
    $records = $this->createQuery('c')
            ->select('c.id')
            ->leftJoinTranslation('c')
            ->whereIn('c.unique_name', $uniqueNames)
            ->fetchArray();
    $ids = array();
    foreach ($records as $record) {
      $ids[] = $record['id'];
    }
    return $ids;
  }

  /** MenuDataCollector * */

  /**
   * Funkcja pobiera kategorie wykorzystujac przekazana tablice ID.
   * 
   * @return array
   */
  public function getCategoriesByIds($categoryIds, $culture) {
    return $this->createQuery('c')
                    ->select('c.id, c.unique_name, c.title_image, ct.name, ct.slug')
                    ->leftJoin('c.Translation ct')
                    ->where('ct.lang = ?', $culture)
                    ->andWhereIn('c.id', $categoryIds)
                    ->execute();
  }

  /** KONIEC - MenuDataCollector * */
  /**
   * artSitemapTask
    
   */

  /**
   * Pobiera wszystkie kategorie z bazy
   * @return array Tablica kategorii
   */
  public function getCategories($culture = false) {
    
    $query = $this->createQuery('c'); 
    
    
    if ($culture){
      $query->leftJoin('c.Translation ct')->where('ct.lang = ?', $culture); 
    }
    
    return $query->execute();
  }

  /** KONIEC - artSitemapTask */
  
  /** MenuItemCategoryForm **/
  
  /**
   * Funkcja pobiera kategorie i konwertuje ja do tablicy ktora moze byc wykorzystana przez widget.
   * 
   * @return array
   */
  public function getCategoriesForMenuItem($culture, $addNewChoice = false) {
    $categories = $this->createQuery('a')
            ->select('a.id, at.name')
            ->leftJoin('a.Translation at')
            ->andWhere('at.lang = ?', $culture)
            ->fetchArray();
    
    $categoriesArray = array();
    if ($addNewChoice) {
      $categoriesArray[] = '-- Nowa Kategoria --';
    }
    
    foreach ($categories as $category) {
      $categoriesArray[$category['id']] = $category['Translation'][$culture]['name'];
    }
    
    return $categoriesArray;
  }
  /** KONIEC - MenuItemCategoryForm **/
  
  /**
   * Pobiera Kategorie do kopiowania przy tworzeniu nowej kategorii 
   * przez FrontendManagement (a dokladnie CategoryForm lub MenuItemCategoryForm).
   * 
   * @param string $uniqueName Unikalna nazwa kategorii
   * @return Category Obiekt kategorii
   */
  public function getCategoryDataForCopy($uniqueName) {
    // WARNING: Pamietac ze jak dodajemy nowe relacje trzeba je uwzglednic w
    // funkcji kopiujacej. PluginArticle->copyFromArray();
    return $this->createQuery('c')
            ->leftJoin('c.Translation ct')
            ->leftJoin('c.articleCategories ac')
            ->where('c.unique_name = ?', $uniqueName)
            ->fetchOne(array(), Doctrine::HYDRATE_ARRAY);
  }
}

