<?php

/**
 * PluginMenuItemTable
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 */
class PluginMenuItemTable extends artDoctrineTable
{
    /**
     * Returns an instance of this class.
     *
     * @return object PluginMenuItemTable
     */
    public static function getInstance()
    {
        return Doctrine_Core::getTable('PluginMenuItem');
    }
    
    public function getMenuItemByOrder($order, $menuGroupId) {
      return $this->createQuery('mi')
              ->leftJoin('mi.Translation')
              ->where('mi.order = ?', $order)
              ->andWhere('mi.menu_id = ?', $menuGroupId)
              ->fetchOne();
    }
    
    public function getMaxOrder($menuGroupId) {
      $object = $this->createQuery('mi')
              ->where('mi.menu_id = ?', $menuGroupId)
              ->orderBy('mi.order DESC')
              ->fetchOne();
      
      if ($object) {
        return $object->getOrder();
      } else {
        return 0;
      }
    }
    
    public function repairOrders($menuGroupId) {
            $objects = $this->createQuery('mi')
              ->where('mi.menu_id = ?', $menuGroupId)
              ->orderBy('mi.order ASC, mi.id DESC')
              ->execute();
      $order = 1;
      
      foreach ($objects as $object) {
        if ($object->getOrder() != $order) {
          $object->setOrder($order);
          $object->save();
        }
        
        $order++;
      }
    }
    
    public function getFlatyMenuItem() {
      return $this->createQuery('mi')
              ->leftJoin('mi.Translation mit')
              ->leftJoin('mi.Menu mg')
              ->leftJoin('mi.Submenu smg');
    }
}