<?php
/**
 * Description of artPhotoConverter
 */

class artPhotoConverter {
  // zmniejsza obrazek tak aby najmniejszy bok mieścił się w docelowym rozmiarze, to co wystaje poza założony rozmiar jest odcinane
  const IMG_CUT_OUT = 0;   
  // zmniejsza obrazek tak aby największy bok mieścił się w docelowym rozmiarze, obrazek ma rozmiar <= od założonego
  const IMG_NO_FILL = 1;   
  // zmniejsza obrazek tak aby największy bok mieścił się w docelowym rozmiarze, obrazek jest ustawiany na środku a pozostałe miejsce jest wypełniane kolorem, kolor może być w rgba
  const IMG_FILL_COLOR = 2;  
  // zmniejsza obrazek tak aby największy bok mieścił się w docelowym rozmiarze, obrazek jest ustawiany na środku na obrazku tła,  rozmiar obrazka będzie taki sam jak rozmiar obrazu tła
  const IMG_FILL_IMG = 3;  
  // brak konwersji
  const IMG_NO_CONVERT = 4;  
  
  /**
   * Metoda zwraca defaultowa tablice ustawien
   * @return array 
   */
  public static function defaultSettings()
  {
    return array(
      'width' => 120,
      'height' => 120,
      'type' => self::IMG_CUT_OUT,
      'color' => '#000000',
      'fill_img' => '/arteneo-theme/images/logo.jpg'
    );
  }
  
  /**
   * Metoda robi resize zdjęcia. Mozliwe parametry opcji:
   * array(
   *   'width' => 120, szerokosc zdjecia po konwersji
   *   'height' => 120, wysokosc zdjecia po konwersji
   *   'type' => self::IMG_CUT_OUT, sposob kowersji (patrz stale klasy)
   *   'color' => '#000000', kolor wypelnienia
   *   'fill_img' => '/arteneo-theme/images/logo.jpg' obrazek wypelnienia
   * );
   * 
   * @param array $params - parametry konwersji
   * @param string $sourceAbsoluteFilePath - plik do konwersji
   * @param string $destinationAbsoluteFilePath - plik po konwersji
   * @return string absolutnia sciezka do pliku po konwersji
   * @throws sfException 
   */
  public static function resizePhoto ($params, $sourceAbsoluteFilePath, $destinationAbsoluteFilePath)
  {
    $params = array_merge(self::defaultSettings(), $params);
    extract($params);
    
    if (!is_file($sourceAbsoluteFilePath))
      throw new sfException('Brak pliku źródłowego '.$sourceAbsoluteFilePath);
   
    if (!is_dir(dirname($destinationAbsoluteFilePath)))
        mkdir(dirname($destinationAbsoluteFilePath), 0777, true);
    
    if (!is_dir(dirname($destinationAbsoluteFilePath)))
      throw new sfException('Nie stworzono katalogu docelowego '.dirname($destinationAbsoluteFilePath));
    
    if ($type == self::IMG_FILL_IMG)
    {
      if (!is_file($fill_img))
        $fill_img = sfConfig::get ('sf_web_dir').$fill_img;
      
      if (!is_file($fill_img))
        throw new sfException('Brak pliku tła '.$fill_img);
    }
    
    $plugins = sfContext::getInstance()->getConfiguration()->getPlugins();
    if (in_array('sfImageTransformPlugin', $plugins)) {
      $img = new sfImage($sourceAbsoluteFilePath);

      switch ($type)
      {
      case self::IMG_CUT_OUT :
          $img->thumbnail($width, $height, 'center');
          break;

      case self::IMG_NO_FILL :
          $img->thumbnail($width, $height, 'scale');
          break;
      
      case self::IMG_FILL_COLOR:
          $img->thumbnail($width, $height, 'fit', $color);
          break;
        
      case self::IMG_FILL_IMG:
          $imgb = new sfImage($fill_img);
          $img->thumbnail($width, $height, 'scale');
          $imgb->overlay ($img, 'center');
          $img = $imgb;
          break;
      }
      $img->saveAs($destinationAbsoluteFilePath);
    } else {

      switch ($type)
      {
        case self::IMG_CUT_OUT :
          passthru("convert " . $sourceAbsoluteFilePath . " -resize " . $width . "x" . $height . "^ -gravity center -extent " . $width . "x" . $height . " " . $destinationAbsoluteFilePath);
          break;

        case self::IMG_NO_FILL :
          passthru("convert " . $sourceAbsoluteFilePath . " -thumbnail " . $width . "x" . $height . " " . $destinationAbsoluteFilePath);
          break;

        case self::IMG_FILL_COLOR :
          passthru("convert " . $sourceAbsoluteFilePath . " -thumbnail " . $width . "x" . $height . " -gravity center -background \"" . $color . "\" -extent " . $width . "x" . $height . " " . $destinationAbsoluteFilePath);
          break;

        case self::IMG_FILL_IMG :
          passthru("convert " . $sourceAbsoluteFilePath . " -thumbnail " . $width . "x" . $height . " " . $fill_img . " +swap -gravity center -composite " . $destinationAbsoluteFilePath);
          break;

        case self::IMG_NO_CONVERT :
          passthru("mv " . $sourceAbsoluteFilePath . " " . $destinationAbsoluteFilePath);
          break;
      }

    }
    if (!is_file($destinationAbsoluteFilePath))
      throw new sfException('Nie stworzono wynikowego pliku '.$destinationAbsoluteFilePath);
   
    return $destinationAbsoluteFilePath;
  }
  
  /**
   * Generuje nazwe pliku jako $prefix_HASH.$extension
   * @param string $prefix - prefix
   * @param string $extension - rozszerzenie
   * @return string 
   */
  public static function generateFileName($prefix, $extension)
  {
    return Slug::slugify($prefix) . '_' . md5(time().$prefix) . $extension ;
  }
 
}

?>
