<?php

class artCmsPluginRedirector
{ 
  /**
   * Przekierowanie gdy request nie jest wywolany przez AJAX
   */
  public static function getNotXmlHttp()  
  {
    return '@homepage';
  }
  
  /** Przekierowania AJAX **/
  /** Uzywane w akcji : return $this->renderText(Redirector::get('XYZ'));**/
  
  /**
   * Przekierowanie gdy brakuje praw do wykonania czynnosci. Ustawia flash.
   * Zwracany jest string 'NoPermission', aby JS mogl zdecydowac co zrobic.
   */
  public static function getAjaxNoPermission($params)  
  {
    $params['user']->setFlash('error', _('Brak praw do wykonania operacji.'));
    return 'NoPermission';
  }
  
  /**
   * Przekierowanie gdy wybrany artykul nie istnieje. Ustawia flash.
   * Zwracany jest string 'ArticleNotExist', aby JS mogl zdecydowac co zrobic.
   */
  public static function getFmArticleNotExist($params)  
  {
    $params['user']->setFlash('error', _('Wybrany artykuł nie istnieje.'));
    return 'ArticleNotExist';
  }
  
  /**
   * Przekierowanie gdy wybrany ArticlePhoto nie istnieje. Ustawia flash.
   * Zwracany jest string 'ArticlePhotoNotExist', aby JS mogl zdecydowac co zrobic.
   */
  public static function getFmArticlePhotoNotExist($params)  
  {
    $params['user']->setFlash('error', _('Wybrane zdjęcie nie istnieje.'));
    return 'ArticlePhotoNotExist';
  }
  
  /**
   * Przekierowanie gdy wybrana referencja nie istnieje. Ustawia flash.
   * Zwracany jest string 'ReferenceNotExist', aby JS mogl zdecydowac co zrobic.
   */
  public static function getFmReferenceNotExist($params)  
  {
    $params['user']->setFlash('error', _('Wybrana referencja nie istnieje.'));
    return 'ReferenceNotExist';
  }
  
  /**
   * Przekierowanie gdy wybrana kategoria nie istnieje. Ustawia flash.
   * Zwracany jest string 'ReferenceNotExist', aby JS mogl zdecydowac co zrobic.
   */
  public static function getFmCategoryNotExist($params)  
  {
    $params['user']->setFlash('error', _('Wybrana kategoria nie istnieje.'));
    return 'CategoryNotExist';
  }
  
  /**
   * Przekierowanie po dodaniu artykułu. Ustawia flash.
   * Zwracany jest string 'Success', aby JS mogl zdecydowac co zrobic.
   */
  public static function getFmArticleAddSuccess($params)  
  {
    $params['user']->setFlash('notice', _('Artykuł został pomyślnie dodany.'));
    return 'Success';
  }
  
  /**
   * Przekierowanie po edycji artykulu. Ustawia flash.
   * Zwracany jest string 'Success', aby JS mogl zdecydowac co zrobic.
   */
  public static function getFmArticleEditSuccess($params)  
  {
    $params['user']->setFlash('notice', _('Artykuł został pomyślnie zaktualizowany.'));
    return 'Success';
  }
  
  /**
   * Przekierowanie po edycji metadanych artykulu. Ustawia flash.
   * Zwracany jest string 'Success', aby JS mogl zdecydowac co zrobic.
   */
  public static function getFmArticleMetaEditSuccess($params)  
  {
    $params['user']->setFlash('notice', _('Metadane artykułu zostały pomyślnie zaktualizowane.'));
    return 'Success';
  }
  
  /**
   * Przekierowanie po zapisie kolejnosci w galleri. Ustawia flash.
   * Zwracany jest string 'Success', aby JS mogl zdecydowac co zrobic.
   */
  public static function getFmGallerySaveOrderSuccess($params)  
  {
    $params['user']->setFlash('notice', _('Kolejność zdjęć została pomyślnie zaktualizowana.'));
    return 'Success';
  }
  
  /**
   * Przekierowanie po dodaniu zdjecia. Ustawia flash.
   * Zwracany jest string 'Success', aby JS mogl zdecydowac co zrobic.
   */
  public static function getFmGalleryPhotoAddSuccess($params)  
  {
    $params['user']->setFlash('notice', _('Zdjęcie zostało pomyślnie dodane.'));
    return 'Success';
  }
  
  /**
   * Przekierowanie po edycji zdjecia. Ustawia flash.
   * Zwracany jest string 'Success', aby JS mogl zdecydowac co zrobic.
   */
  public static function getFmGalleryPhotoEditSuccess($params)  
  {
    $params['user']->setFlash('notice', _('Zdjęcie zostało pomyślnie zaktualizowane.'));
    return 'Success';
  }
  
  /**
   * Przekierowanie po usunieciu zdjecia. Ustawia flash.
   * Zwracany jest string 'Success', aby JS mogl zdecydowac co zrobic.
   */
  public static function getFmGalleryPhotoDeleteSuccess($params)  
  {
    $params['user']->setFlash('notice', _('Zdjęcie zostało pomyślnie usunięte.'));
    return 'Success';
  }
  
  /**
   * Przekierowanie po usunieciu artykulu. Ustawia flash.
   * Zwracany jest string 'Success', aby JS mogl zdecydowac co zrobic.
   */
  public static function getFmArticleDeleteSuccess($params)  
  {
    $params['user']->setFlash('notice', _('Artykuł został pomyślnie usunięty.'));
    return 'Success';
  }
  
  /**
   * Przekierowanie po dodaniu referencji. Ustawia flash.
   * Zwracany jest string 'Success', aby JS mogl zdecydowac co zrobic.
   */
  public static function getFmReferenceAddSuccess($params)  
  {
    $params['user']->setFlash('notice', _('Referencja została pomyślnie dodana.'));
    return 'Success';
  }
  
  /**
   * Przekierowanie po edycji referencji. Ustawia flash.
   * Zwracany jest string 'Success', aby JS mogl zdecydowac co zrobic.
   */
  public static function getFmReferenceEditSuccess($params)  
  {
    $params['user']->setFlash('notice', _('Referencja została pomyślnie zaktualizowana.'));
    return 'Success';
  }
  
  /**
   * Przekierowanie po usunieciu referencji. Ustawia flash.
   * Zwracany jest string 'Success', aby JS mogl zdecydowac co zrobic.
   */
  public static function getFmReferenceDeleteSuccess($params)  
  {
    $params['user']->setFlash('notice', _('Referencja została pomyślnie usunięta.'));
    return 'Success';
  }
  
  /**
   * Przekierowanie po dodaniu kategorii. Ustawia flash.
   * Zwracany jest string 'Success', aby JS mogl zdecydowac co zrobic.
   */
  public static function getFmCategoryAddSuccess($params)  
  {
    $params['user']->setFlash('notice', _('Kategoria została pomyślnie dodana.'));
    return 'Success';
  }
  
  /**
   * Przekierowanie po edycji kategorii. Ustawia flash.
   * Zwracany jest string 'Success', aby JS mogl zdecydowac co zrobic.
   */
  public static function getFmCategoryEditSuccess($params)  
  {
    $params['user']->setFlash('notice', _('Kategoria została pomyślnie zaktualizowana.'));
    return 'Success';
  }
  
  /**
   * Przekierowanie po usunieciu kategorii. Ustawia flash.
   * Zwracany jest string 'Success', aby JS mogl zdecydowac co zrobic.
   */
  public static function getFmCategoryDeleteSuccess($params)  
  {
    $params['user']->setFlash('notice', _('Kategoria została pomyślnie usunięta.'));
    return 'Success';
  }
  
  /**
   * Przekierowanie po zmianie kolejnosci elementow. Ustawia flash.
   * Zwracany jest string 'Success', aby JS mogl zdecydowac co zrobic.
   */
  public static function getFmChangeOrderSuccess($params)  
  {
    $params['user']->setFlash('notice', _('Kolejność elementów została pomyślnie zaktualizowana.'));
    return 'Success';
  }
  
  /**
   * Przekierowanie po zmianie kolejnosci elementow. Ustawia flash.
   * Zwracany jest string 'Error', aby JS mogl zdecydowac co zrobic.
   */
  public static function getFmChangeOrderError($params)  
  {
    $params['user']->setFlash('error', _('Wystąpił błąd. Kolejność elementów nie została zaktualizowana.'));
    return 'Error';
  }

  /**
   * Przekierowanie po wyslaniu wiadomosci kontaktowej. Ustawia flash.
   * Zwracany jest string 'Success', aby JS mogl zdecydowac co zrobic.
   */
  public static function getAjaxContactFormSuccess($params)
  {
    $params['user']->setFlash('notice', _('Wiadomość została wysłana.'));
    return 'Success';
  }
  
  /** KONIEC - Przekierowania AJAX **/
  
  /**
   * Przekierowanie po wyslaniu wiadomosci kontaktowej.
   */
  public static function getContactFormSuccess($params)
  {
    $params['user']->setFlash('notice', _('Wiadomość została wysłana.'));
    return '@contact';
  }
  
}