<?php

class ArticleSettings {

  private static $options = array(
      'author' => 'd8bdde6f28e6de6ffc5deed9039965f5',
      'tags' => '40787f241349515676286cc360868494',
      'views' => 'c7b0c49820c041647aef9883551d678c',
      'social-buttons' => '8836ceec4330fa25a9c8b224d61fccb7',
      'votes' => '3b30898e6491f2f174412b3b263f1c5c',
      'see-also' => 'f45d870294f6e86fd1a7152f4e3cd85c',
      'comments' => '165fb55bf18afc42168f6ea4f6c40048',
      'big-image' => '40262a955052ce5bd612cc9a55e6e947',
      'exports' => '6e2d2289d2126e84457a1c28711e6656',
      'permissions-and-groups' => '8730c9122778bda6ab3311e17833a04e',
      'source' => '28d689ed1f1838c1de3ea2ee3270203c',
      'gallery' => '00f6b9c8e12b0e60f9cd7b7f5ab2c539',
      'contact-form' => '4fcb62c5e3c1347ea4da51fb5a95f2aa',
      'shares-belt' => '25cdcfad4f7eeefb5bc83d9caed9185f'
  );
  
  private static $config = null;

  private static function readAndDecode() {
    if (empty(self::$config))
      self::$config = parse_ini_file(sfConfig::get('sf_config_dir') . '/articles_config.ini');
  }

  public static function has($option) {
    self::readAndDecode();

    return (isset(self::$config[$option]) && self::$config[$option] == self::$options[$option]);
  }

  public static function hasTags() {
    return self::has('tags');
  }

  public static function hasExports() {
    return self::has('exports');
  }

  public static function hasPermissionsAndGroups() {
    return self::has('permissions-and-groups');
  }

  public static function hasSeeAlso() {
    return self::has('see-also');
  }

  public static function hasSharesBelt(){
    return self::has('shares-belt');
  }

  public static function hasSource() {
    return self::has('source');
  }

  public static function hasSocials() {
    return self::has('social-buttons');
  }

  public static function hasBigImage() {
    return self::has('big-image');
  }

  public static function hasComments() {
    return self::has('comments');
  }

  public static function hasVotes() {
    return self::has('votes');
  }

  public static function hasViews() {
    return self::has('views');
  }

  public static function hasGallery() {
    return self::has('gallery');
  }

  public static function hasContactForm() {
    return self::has('contact-form');
  }

  public static function guestCanComment() {
    self::readAndDecode();

    return (isset(self::$config['guest-can-comment']) && self::$config['guest-can-comment'] == true);
  }

}
