<?php

/**
 * Description of PluginPaArticleTabFormConfiguration
 *
 
 */
class PluginPaArticleTabFormConfiguration extends BaseTabFormConfiguration
{

  protected $configuration = array(
      'ArticleTab' => array(
          'form_class' => 'ArticleForm',
          'foreign_key_name' => 'id',
          'doctrine_object_class' => 'Article',
      ),
      'ArticleAdvancedTab' => array(
          'form_class' => 'ArticleAdvancedForm',
          'multipart_form' => true,
          'foreign_key_name' => 'id',
          'required_foreign_keys' => array('id'),
          'doctrine_object_class' => 'Article',
      ),
      'GalleryTab' => array(
          'required_foreign_keys' => array('id'),
          'multipart_form' => true,
      ),
      'FilesTab' => array(
          'required_foreign_keys' => array('id'),
          'multipart_form' => true,
      )
  );

  public function __construct(artTabActions $actionsObject)
  {
    if (!sfConfig::get('app_article_with_files_tab', false))
      unset($this->configuration['FilesTab']);
    
    parent::__construct($actionsObject);
  }
}
