<?php

/**
 * artWidgetFormSchemaFormatterBootstrap wykorzystywany do generowania formularza
 * w postaci Boostrapowej
 *
 * @package    lib
 * @subpackage formatter

 */
class artWidgetFormSchemaFormatterFlaty extends artWidgetFormSchemaFormatter {

  protected
      $rowFormat = '
          <div class="form-group %is_error%">
              %label%
              <div class="%bootstrapCol% controls">
                  %field%
                  %error%
              </div>
              %hidden_fields%
          </div>',
      $errorRowFormat = "%errors%",
      $helpFormat = '%help%',
      $errorListFormatInARow = "<span class='help-block has-error'>\n%errors%\n</span>\n",
      $errorRowFormatInARow = "%error%\n",
      $namedErrorRowFormatInARow = "<span class='help-block'>%name% %error%</span>\n",
          
          $rowEmbedded = '
            <div class="row shortcode_tabs tabs">
              <div class="all_heads_cont col-md-12 tabs-header" style="display:inline-block;">
                %headers%
              </div>
              <div class="all_body_cont col-md-12 tabs-content">
                %containers%
              </div>
            </div>',
      $headerEmbedded = '<div class="shortcode_tab_item_title btn btn-primary %boostrapCol%%active%%is_error%" onclick="ManageForm.changeTab(this, \'%container%\');">%icon%<span>%label%</span></div>',
      $containerEmbedded = '<div class="shortcode_tab_item_body %container%%active%%is_error%">
              %content%</div>',
          
          
      $decoratorFormat = "%content%",
      $translationCatalogue = 'messages',
      $embeddedIcons = false;

  public function formatRow($label, $field, $errors = array(), $help = '', $hiddenFields = null, $isEmbedded = false) {
    return strtr($this->getRowFormat(), array(
      '%label%'         => $label,
      '%field%'         => $field,
      '%error%'         => $this->formatErrorsForRow($errors),
      '%help%'          => $this->formatHelp($help),
      '%bootstrapCol%'  => ($isEmbedded ? 'col-md-12' : 'col-sm-9 col-lg-10'),
      '%hidden_fields%' => null === $hiddenFields ? '%hidden_fields%' : $hiddenFields,
      '%is_error%' => (count($errors) > 0) ? 'has-error' : '',
      '%class%' => Slug::slugify($label, '_'),
    ));
  }

  /**
   * Nadpisana zeby w przypadku ustawienia label na false nic nie generowac oraz
   * dodaje atrybuty potrzebne do html dla labeli
   * @param type $name
   * @param type $attributes
   * @return string
   */
  public function generateLabel($name, $attributes = array()) {
    $labelName = $this->generateLabelName($name);

    if (false === $this->widgetSchema->getLabel($name)) {
      return '';
    }

    if (!isset($attributes['for'])) {
      $attributes['for'] = $this->widgetSchema->generateId($this->widgetSchema->generateName($name));

      if (isset($attributes['class'])) {
        $attributes['class'] .= 'control-label';
      } else {
        $attributes['class'] = 'control-label';
      }
    }

    $attributes['class'] .= 'col-sm-3 col-lg-2 control-label';

    return $this->widgetSchema->renderContentTag('label', $labelName, $attributes);
  }
  
    /**
   * Nie chcemy aby errory byly propagowane do samej gory, wiec nadpisujemy funkcje
   * @param type $errors
   * @param type $prefix
   * @return type
   */
  protected function unnestErrors($errors, $prefix = '') {
    $newErrors = array();

    foreach ($errors as $name => $error) {
      if ($error instanceof ArrayAccess || is_array($error)) {
        // Nie chcemy zeby nam errory byly propagowane do samej gory
        //$newErrors = array_merge($newErrors, $this->unnestErrors($error, ($prefix ? $prefix . ' > ' : '') . $name));
      } else {
        if ($error instanceof sfValidatorError) {
          $err = $this->translate($error->getMessageFormat(), $error->getArguments());
        } else {
          $err = $this->translate($error);
        }

        if (!is_integer($name)) {
          $newErrors[] = strtr($this->getNamedErrorRowFormatInARow(), array('%error%' => $err, '%name%' => ($prefix ? $prefix . ' > ' : '') . $name));
        } else {
          $newErrors[] = strtr($this->getErrorRowFormatInARow(), array('%error%' => $err));
        }
      }
    }

    return $newErrors;
  }

  
  /**
   * Funkcja wykorzystywana do stworzenia tablicy z danymi do renderowania zakladek.
   * @param type $name
   * @param type $field
   * @param type $errors
   * @param type $help
   * @param type $hiddenFields
   * @param type $active
   * @return type
   */
  public function formatRowEmbedded($name, $field, $errors = array(), $help = '', $hiddenFields = null, $active = false) {
    $labelName = $this->generateLabelName($name);
    $containerName = $name;
    
    $icon = '';
    if ($this->embeddedIcons) {
      $icon = '<i class="glyphicon glyphicon-'.$name.'"></i>';
    }

    $header = strtr($this->headerEmbedded, array(
      '%label%' => $labelName,
      '%container%' => $containerName,
      '%icon%' => $icon,
      '%is_error%' => (count($errors) > 0) ? ' error' : '',
      '%active%' => ($active) ? ' active' : '',
    ));
    
    $container = strtr($this->containerEmbedded, array(
      '%content%' => $this->formatRow('', $field, $errors, $help, $hiddenFields, true),
      '%container%' => $containerName,
      '%is_error%' => (count($errors) > 0) ? ' error' : '',
      '%active%' => ($active) ? ' active' : '',
    ));
        
    return array(
      'header' => $header,
      'container' => $container,
    );
  }

  /**
   * Funkcja renderuje zakladki
   * @param type $rows
   * @return type
   */
  public function formatRowsEmbedded($rows) {
    $header = '';
    $container = '';

    $rowsCount = count($rows);
    $boostrapCol = 12;
    if ($rowsCount == 2) {
      $boostrapCol = 6;
    } elseif ($rowsCount == 3) {
      $boostrapCol = 4;
    } elseif ($rowsCount == 4) {
      $boostrapCol = 3;
    } elseif ($rowsCount != 1) {
      $boostrapCol = 1;
    }
    foreach ($rows as $row) {
      $header .= $row['header'];
    }

    foreach ($rows as $row) {
      $container .= $row['container'];
    }
    
    $header = strtr($header, array(
        '%boostrapCol%' => 'col-md-'.$boostrapCol
    ));
    
    return strtr($this->rowEmbedded, array(
      '%headers%' => $header,
      '%containers%' => $container,
    ));
  }
}
