<?php


class flatyWidgetFormSchema extends artWidgetFormSchema
{
    private $ajaxImageFields = array();

    protected
        $informations = array();

    /**
     * Konstructor.
     *
     *
     * @param mixed $fields     Pola formularza
     * @param array $options    Tablica z opcjami
     * @param array $attributes Tablica z parametrmi CSS
     * @param array $labels     Tablica z labelkami do widgetów
     * @param array $helps      Tablica z podpowidziami do pól formularza.
     * @param array $informations     Tablica z informacjami do pól formularza.
     *
     * @throws InvalidArgumentException Gdy podane pola nie są null lub tablicą
     *
     * @see sfWidgetForm
     */
    public function __construct($fields = null, $options = array(), $attributes = array(), $labels = array(), $helps = array(), $informations = array())
    {
        $this->addOption('name_format', '%s');
        $this->addOption('form_formatter', null);

        parent::__construct($options, $attributes);

        if (is_array($fields)) {
            foreach ($fields as $name => $widget) {
                $this[$name] = $widget;
            }
        } else if (null !== $fields) {
            throw new InvalidArgumentException('sfWidgetFormSchema constructor takes an array of sfWidget objects.');
        }

        $this->setLabels($labels);
        $this->helps = $helps;
        $this->informations = $informations;
    }

    /**
     * Render Widgeta
     *
     * @param string $name       Nazwa HTML Widgeta
     * @param mixed  $values     Wartośći do widgeta,
     * @param array  $attributes Tablica z parametrami HTML
     * @param array  $errors     Tablica z błędami
     *
     * @return string HTML reprezentujący Widget.
     *
     * @throws InvalidArgumentException kiedy wartości typów nie są array|ArrayAccess
     */
    public function render($name, $values = array(), $attributes = array(), $errors = array())
    {
        if (null === $values) {
            $values = array();
        }

        if (!is_array($values) && !$values instanceof ArrayAccess) {
            throw new InvalidArgumentException('You must pass an array of values to render a widget schema');
        }

        $formFormat = $this->getFormFormatter();

        $rows = array();
        $hiddenRows = array();
        $errorRows = array();

        // render each field
        foreach ($this->positions as $name) {
            $widget = $this[$name];
            $value = isset($values[$name]) ? $values[$name] : null;
            $error = isset($errors[$name]) ? $errors[$name] : array();
            $widgetAttributes = isset($attributes[$name]) ? $attributes[$name] : array();
            if (isset($widgetAttributes['class'])) {
              $widgetAttributes['class'] .= 'form-control';
            } else {
              $widgetAttributes['class'] = 'form-control';
            }
            var_dump($widgetAttributes);

            if ($widget instanceof sfWidgetForm && $widget->isHidden()) {
                $hiddenRows[] = $this->renderField($name, $value, $widgetAttributes);
            } else {
                $field = $this->renderField($name, $value, $widgetAttributes, $error, $help = '', $hiddenFields = null, $info = '');

                // don't add a label tag and errors if we embed a form schema,
                $label = $widget instanceof artWidgetFormSchema ? $this->getFormFormatter()->generateLabelName($name) : $this->getFormFormatter()->generateLabel($name);
                $error = $widget instanceof artWidgetFormSchema ? array() : $error;

                $rows[] = $formFormat->formatRow($label, $field, $error, $this->getHelp($name), null , $this->getInfo($name));
            }
        }

        if ($rows) {
            // insert hidden fields in the last row
            for ($i = 0, $max = count($rows); $i < $max; $i++) {
                $rows[$i] = strtr($rows[$i], array('%hidden_fields%' => $i == $max - 1 ? implode("\n", $hiddenRows) : ''));
            }
        } else {
            // only hidden fields
            $rows[0] = implode("\n", $hiddenRows);
        }

        return $this->getFormFormatter()->formatErrorRow($this->getGlobalErrors($errors)) . implode('', $rows);
    }


    /**
     * Delikatna modyfikacja funkcji po to, aby łatwo można było obsłużyć ajaxowe dodawanie obrazków
     */
    public function offsetSet($name, $widget)
    {
        parent::offsetSet($name, $widget);

        //jeżeli dany widget jest widgetem do ajaxowego uploadu obrazkow, to dodaj jego nazwę do tablicy $ajaxImageFields,
        //aby pozniej w funkcji bind() formularza wiedziec,
        if ($widget instanceof sfArtWidgetFormInputAjaxInterface)
            $this->ajaxImageFields[] = $name;
    }

    /**
     * Delikatna modyfikacja funkcji po to, aby łatwo można było obsłużyć ajaxowe dodawanie obrazków
     */
    public function offsetUnset($name)
    {
        if (in_array($name, $this->ajaxImageFields))
            unset($this->ajaxImageFields[array_search($name, $this->ajaxImageFields)]);

        parent::offsetUnset($name);
    }

    /*
     * Pobiera pola z obrazkami // AJAX
     */
    public function getAjaxImageFields()
    {
        return $this->ajaxImageFields;
    }

    /*
     * Nadpisanie klasy Form Schema Formattera.
     */
    public function getFormFormatter()
    {
        $name = $this->getFormFormatterName();

        if (!isset($this->formFormatters[$name])) {
            $class = 'artWidgetFormSchemaFormatter' . ucfirst($name);

            if (!class_exists($class))
                throw new InvalidArgumentException(sprintf('Formater formularza o nazwie "%s" nie istnieje.', $name));

            $this->formFormatters[$name] = new $class($this);
        }

        return $this->formFormatters[$name];
    }

    /*
     * Pobiera pola.
     */
    public function getField($name)
    {
        return $this->fields[$name];
    }

    /**
     * Ustawia text artykułu do rendera dla każdego z pól.
     *
     * @param array $informations Tablicę z tekstami artykułów.
     *
     * @return sfWidget The current widget instance
     */
    public function setInformations(array $informations)
    {
        $this->informations = $informations;

        return $this;
    }

    /**
     * Ustawia text informacji.
     * @return array Tablica z tekstami informations.
     */
    public function getInformations()
    {
        return $this->informations;
    }

    /**
     *
     * Ustawia text informacji
     *
     * @param string $name Nazwa pola
     * @param string $help Text informacji
     *
     * @return sfWidget The current widget instance
     */
    public function setInfo($name, $info)
    {
        $this->informations[$name] = $info;

        return $this;
    }

    /**
     * Pobiera text informacji po nazwie pola
     *
     * @param string $name Nazwa pola formularza
     *
     * @return string Text informacji lub pusty string gdy nie znaleziono.
     */
    public function getInfo($name)
    {
        return array_key_exists($name, $this->informations) ? $this->informations[$name] : '';
    }
}
