<?php if ($article->hasTitle() || $article->hasBreadcrumbs()): ?>
  <div class="page_title_block">
    <div class="container">

      <h1 class="article title" <?= inline_attr($article, 'title'); ?>>
        <?= $article->getEscapedTitle(); ?>
      </h1>

      <?= new FmActionBar($article); ?>

      <?php if ($article->hasBreadcrumbs()): ?>
        <div class="breadcrumbs">
          <a href="<?= url_for('@homepage') ?>"><?= __('Strona Główna'); ?></a>
          <?php $categoryObject = $article->getCategories()->getFirst(); ?>
          <?php if (isset($categoryObject) && !is_null($categoryObject) && is_object($categoryObject)): ?>
            <?php if ($categoryObject->getUniqueName() != 'menu'): ?>
              <a href="<?= $categoryObject->getUrl() ?>"><?= $categoryObject->getName(); ?></a>
            <?php endif; ?>
          <?php endif; ?>
          <span><?= $article->getEscapedTitle(); ?></span>
        </div>
      <?php endif; ?>
    </div>
  </div>
<?php endif; ?>