<?php if ($articles->count() > 0) : ?>
  <?php foreach ($articles as $article): ?>
    <div class="blog_post_preview">
      <div class="blog_head">
        <span class="blogpost_type_ico post_type_gallery"></span>

        <div class="bg_title">
          <?php if ($categoryObject->hasLinks()): ?>
            <h3><a href="<?= $article->getUrl(); ?>" class="blogpost_title"  <?= inline_attr($article, 'title'); ?>>
              <?= $article->getEscapedTitle(); ?></a>
            </h3>
          <?php else: ?>
            <h3 <?= inline_attr($article, 'title'); ?>><?= $article->getEscapedTitle(); ?>
            </h3>
          <?php endif; ?>
            <?= new FmActionBar($article); ?>
        </div>

        <?php include_partial('article_meta', array('article' => $article)); ?>
      </div><!-- .blog_head -->

      <?php if ($categoryObject->hasBigImage() && $article->getBigImage() != ''): ?>
        <div class="featured_image_full img-polaroid">
          <img src="<?= Article::getBigImagePath() . $article->getBigImage() ?>" alt="" width="1170" height="470" />
        </div><!-- .featured_image_full -->
      <?php endif; ?>

      <?php if ($categoryObject->hasShortDescription() || $categoryObject->hasMoreLink()): ?>
        <article class="contentarea">
          <?php if ($categoryObject->hasShortDescription()): ?>
            <div <?= inline_attr($article, 'short_description'); ?>>
              <?php $article->getShortDescriptionHtml(); ?>
            </div>
          <?php endif; ?>

          <?php if ($categoryObject->hasMoreLink()): ?>
            <a href="<?= $article->getUrl(); ?>" class="more-link"><?= __("Więcej"); ?></a>
          <?php endif; ?>
            
          <?php inline_edit($article) ?>
        </article>
      <?php endif; ?>
    </div><!--.blog_post_preview -->
  <?php endforeach ?>
<?php else: ?>
  <div class="row-fluid">                                
    <div class="span12 module_cont module_promo_text module_small_padding">
      <div class="shortcode_promoblock ">
        <div class="span9">
          <h3><?= __("Brak wyników !"); ?></h3>
          <h6><?= __("Przepraszamy, w tym miejscu nie ma niczego do zobaczenia."); ?></h6>
        </div>
        <div class="promo_button_block span3">
          <a class="promo_button" href="<?= url_for('@homepage') ?>"><?= __t("Strona główna") ?></a>
        </div>                                            
      </div>
      <a id="anchor7"></a>
    </div><!--.module_cont -->
    <div class="clear"><!-- ClearFIX --></div>                                                                    
  </div>
<?php endif ?>