
<div class="<?= (isset($position)) ? $position : 'right'; ?>-sidebar-block span3">
  <aside class="sidebar">
    <div class="sidepanel widget_posts">
      <div class="bg_title"><h3 class="sidebar_header"><?= __("Ostatnie posty") ?></h3></div>
      <ul class="recent_posts">
        <?php foreach ($articles as $key => $article): ?>
          <li>
            <div class="recent_posts_img">
              <?php if ($article->getTitleImage() != ''): ?>
                <img src="<?= Article::getTitleImagePath() . $article->getTitleImage() ?>" alt="" width="88" height="88"/>
              <?php else: ?>
                <img src="<?= url_for('@placehold') . '?88-88-CCCCCC-969696&text=' . $article->getEscapedTitle(); ?>" alt="" width="88" height="88"/>
              <?php endif; ?>
            </div>
            <div class="recent_posts_content">
              <a href="<?= $article->getUrl(); ?>" class="post_title"><?= $article->getEscapedTitle(); ?></a>
              <?= new FmActionBar($article,array('whitelist' => array('article_edit'))); ?>
              <?= artStringConverter::addOnly3Dotes($article->getEscapedShortDescription(), 100); ?>
            </div>
            <div class="clear"></div>
          </li>
        <?php endforeach; ?>
      </ul>
    </div><!-- .sidepanel -->


    <div class="sidepanel widget_mailchimpsf_widget" inline="<?= $aboutArticle->getId(); ?>">
      <div class="bg_title">
        <h3 class="sidebar_header"<?= inline_attr($aboutArticle, 'title'); ?> >
          <?= $aboutArticle->getEscapedTitle(); ?>
        </h3>
        <?= new FmActionBar($aboutArticle, array('whitelist' => array('article_edit'))); ?>
      </div>
      <div <?= inline_attr($aboutArticle, 'description'); ?>>
        <?php $aboutArticle->getDescriptionHtml(); ?>
      </div>
      <?php inline_edit($aboutArticle) ?>
    </div><!-- .sidepanel -->

    <div class="clear"></div>

    <div class="sidepanel widget_flickr">
      <div class="bg_title">
        <h3 class="sidebar_header"><?= __('Flickr Zdjęcia'); ?></h3>
      </div>
      <div class="flickr_widget_wrapper">
        <script 
        src="http://www.flickr.com/badge_code_v2.gne?count=6&amp;display=latest&amp;size=s&amp;layout=x&amp;source=user&amp;user=<?= ArtConfiguration::getConfig('flickr_username', '92335820@N08') ?>"></script>
      </div>
    </div><!-- .sidepanel -->

    <div class="clear"></div>

    <div class="sidepanel widget_tag_cloud">
      <div class="bg_title">
        <h3 class="sidebar_header"><?= __('Tagi'); ?></h3>
      </div>
      <div class="tagcloud">
        <?php
        $vars = sfContext::getInstance()->getResponse()->getMetas();
        foreach (explode(',', $vars['keywords']) as $key => $value):
          ?>
          <a href="<?= url_for('@search?searchText='.$value); ?>"><?= $value ?></a>
        <?php endforeach; ?>
      </div>
      <div class="clear"></div>
    </div><!-- .sidepanel -->
  </aside>
</div><!-- .right-sidebar -->