<div class="fullscreen_block" id="article-<?= $article->getId() ?>" inline="<?= $article->getId(); ?>">
  <?php include_partial('category_title_fs', array('article' => $article, 'inlineEdit' => $sf_user->hasInlineEdit())) ?>
  <?php include_partial('article_gallery_fs', array('article' => $article)) ?>

  <div class="fullscreen_content">
    <?php include_partial('article_toggle', array('article' => $article)) ?>

    <div class="fullscreen_content_padding">
      <div class="blog_head">
        <span class="blogpost_type_ico post_type_gallery"></span>
        <div class="bg_title">
          <h3><a href="<?=  $article->getUrl(); ?>" class="blogpost_title" <?= inline_attr($article, 'title'); ?>>
              <?= $article->getEscapedTitle(); ?></a>
          </h3>
          <?= new FmActionBar($article); ?>
        </div>
      </div>

      <?php include_partial('article_meta_fs', array('article' => $article)); ?>

      <?php if ($article->hasShortDescription()): ?>
        <div class="row-fluid">
          <div class="span12 module_cont module_text_area module_small_padding">
            <div class="cke-article-text" <?= inline_attr($article, 'short_description'); ?>>
              <?php $article->getShortDescriptionHtml() ?>
            </div>
          </div>								
        </div><!-- .row-fluid -->
      <?php endif; ?>

      <?php if ($article->hasDescription()): ?>
        <div class="row-fluid">
          <div class="span12 module_cont module_text_area module_small_padding">
            <div class="cke-article-text" <?= inline_attr($article, 'description'); ?>>
              <?php $article->getDescriptionHtml() ?>
            </div>
          </div>								
        </div><!-- .row-fluid -->
      <?php endif; ?>

      <div class="row-fluid">
        <div class="span12 module_cont module_text_area module_small_padding">
          <?php inline_edit($article) ?>
        </div>								
      </div><!-- .row-fluid -->

      <?php include_partial('article_social', array('article' => $article)); ?>

      <div class="row-fluid">
        <div class="span12 module_cont module_text_area module_small_padding">
          <div id="commentform">
            <?= include_module_action('comments', 'comments'); ?>
          </div>
        </div>
      </div>
    </div><!-- .fullscreen_content_padding -->
  </div><!-- .fullscreen_content -->
</div> 
<?php if ($article->hasHeaderOnTop()): ?>
  <div class="header2top"></div>
<?php endif; ?>