<?php

class artCmsPluginCommentsActions extends artCmsPluginActions {

  /**
   * 
   * @param type $request
   * @return string
   */
  public function executeComments($request) {

    $this->setLayout(false);
    $this->form = new ArticleCommentForm();
    $this->article = $this->getRequestParameter('object', NULL);

    if (empty($this->article)) {
      $this->article = $this->getObject($request);
    }

    if (empty($this->article)) {
      $this->forward404("Brak obiektu artykułu");
    }

    if ($request->isMethod('post') && $request->hasParameter($this->form->getName())) {

      $this->form->bind($request->getParameter($this->form->getName()));

      if ($this->form->isValid()) {
        $data = $this->form->getValues();
        $this->form->setDefault('article_id', $this->article->getId());
        $this->form->setDefault('user_id', $this->getUser()->getId());
        $this->getResponse()->setCookie('article_comment_nick', $data['nick']);
        $this->form->save();
      }
    }

    $this->comments = Doctrine::getTable('ArticleComment')->findByArticleId($this->article->getId());
    return '';
  }

}
