<?php

class artCmsPluginContactActions extends artCmsPluginActions {

  /**
   * Akcja formularza kontaktowego. W $request mozna przekazac parametry:
   * 'first_article' - unique_name artykulu nad formularzem
   * 'second_article' - unique_name artykulu pod formularzem
   * 'form_name' - nazwa klasy formularza kontaktowego (defaultowo ContactForm)
   * 
   * Do first/second_article mozna przekazac false lub nie ustawiac wcale,
   * wtedy artykul sie nie wyswietli.
   * 
   * routing.yml: contact_form_pl / contact_form_en
   * 
   * @param sfWebRequest $request
   */
  public function executeShow(sfWebRequest $request) {

    $this->articleFirst = $this->getRequest()->getParameter('object', NULL);
    
    if(empty($this->articleFirst)){
      $this->forward404("Brak obiektu artykułu");
    }

    if (sfConfig::get('app_art_cms_plugin_contact_slot', FALSE))
      $this->getResponse()->setSlot("article", $this->articleFirst);

    $view = $this->articleFirst->getLayout()->getView();

    $this->setLayout("layout_$view");

    $this->articleSecond = $this->getContactArticle($request->getParameter('second_article', false));

    return $view;
  }

  /**
   * Funkcja zwraca parametry dla url kontaktowego w przypadku AJAX.
   * 
   * @param sfWebRequest $request
   * @return string 
   */
  protected function getContactUrlParams($request) {   
      if ($request->hasParameter('form_name')) {
        return '?form_name=' . $request->getParameter('form_name');
      }
      return '';
  }

  /**
   * Funkcja zwraca formularz kontaktowy na podstawie parametru z $request
   * 'form_name' lub defaultowo 'ContactForm'
   * 
   * @param sfWebRequest $request
   * @return sfForm
   * @throws sfException 
   */
  protected function getContactForm($request) {
    $contactForm = $request->getParameter('form_name', 'ContactForm');

    if (!class_exists($contactForm)) {
      throw new sfException('Brak klasy formularza kontaktowego "' . $contactForm . '"');
    }

    return new $contactForm;
  }

  /**
   * Zwraca artykul o podanym unique_name. Jesli $uniqueName = false, zwraca false
   * @param string $uniqueName
   * @return mixed false OR Article
   * @throws Exception 
   */
  protected function getContactArticle($uniqueName) {

    if ($uniqueName) {
      $article = Doctrine::getTable('Article')->getArticleByUniqueName($uniqueName);

      if (empty($article)) {
        $this->forward404("Artykuł o unikalnej nazwie $uniqueName nie istnieje w bazie danych.");
      }

      return $article;
    }

    return false;
  }

  /**
   * Akcja AJAX formularza kontaktowego.
   * routing.yml: ajax_contact_form
   * 
   * @param sfWebRequest $request
   */
  public function executeContactForm(sfWebRequest $request) {
    $this->setLayout(false);

    $this->send = false;
    $this->form = $this->getContactForm($request);

    if ($this->parseContactForm($request, $this->form)) {
      $this->send = true;
    }

    $this->urlParams = $this->getContactUrlParams($request);

    return "";
  }

  /**
   * Obsluguje formularz kontaktowy. Jesli jest poprawny wysyla wiadomosc i zwraca TRUE,
   * w przeciwnym wypadku FALSE
   * @param sfWebRequest $request
   * @param sfForm $form
   * @return boolean 
   */
  public function parseContactForm($request, $form) {
    if ($request->isMethod('post') && $request->hasParameter($form->getName())) {
      $form->bind($request->getParameter($form->getName()));

      if ($form->isValid()) {
        $formValues = $form->getValues();
        $message = '';

        foreach (array_keys($formValues) as $field) {
          $message .= __($field) . ' : ' . $formValues[$field] . '<br/>';
        }

        $email = ArtConfiguration::getConfig('contact_email', false);

        ProjectSimpleMessenger::sendContactFormMessage($email, $message);

        return true;
      }
    }
    return false;
  }

}
