<?php include_partial('frontendManagement/modal_begin', $this->getAttributes()); ?>

<div class="modal-body <?= $model; ?>">

    <table class="table table-striped table-hover fill-head">
        <thead>
            <tr>
                <th><?= __t('Nazwa', array(), 'fm'); ?></th>
                <th><?= __t('Aktualna wartość', array(), 'fm'); ?></th>
                <th style="width: 150px"><?= __t('Operacje', array(), 'fm'); ?></th>
            </tr>
        </thead>
        <tbody>
            <?php if ($pager->getNbResults() > 0) : ?>
                <?php foreach ($pager->getResults() as $order => $element) : ?>
                    <tr>
                        <td><?= artStringConverter::addOnly3Dotes($element->getHint(), 100); ?></td>
                        <td><?= artStringConverter::addOnly3Dotes($element->getValue(), 100); ?></td>
                        <td>
                            <button class="btn btn-primary" href="javascript:void(0);" onclick="ManageForm.startIndicator(ManageForm.getPopupContent()); ManageForm.artConfigurationEdit(this, '<?= $element->getId(); ?>');">
                                <i class="icon-edit"></i> <?= __('Edytuj'); ?>
                            </button>
                    </tr>
                <?php endforeach; ?>
            <?php else : ?>
                <tr>
                    <td colspan="3"><?= __t('Brak wyników', array(), 'fm'); ?></td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>

    <?php if ($pager->haveToPaginate()) : ?>
        <div class="row">
            <ul class="pagination pagination-colory">
                <?php foreach ($pager->getLinks() as $page) : ?>
                    <li class="<?= ($page == $pager->getPage() ? 'active' : ''); ?>"><a href="#" onclick="ManageForm.startIndicator(ManageForm.getPopupContent());
                            ManageForm.artConfigurationList(this, '<?= $page; ?>');"><?= $page; ?></a></li>
    <?php endforeach; ?>
            </ul>
        </div>
<?php endif; ?>
</div>

<div class="modal-footer">
</div>

<?php include_partial('frontendManagement/modal_end', $this->getAttributes()); ?>

