<?php include_partial('frontendManagement/modal_begin', $this->getAttributes()); ?>

<?php if ($pager->getNbResults() > 0) : ?>
    <table class="table table-striped table-hover fill-head">
        <thead>
            <tr>
                <th><?= __t('Miniaturka', array(), 'fm'); ?></th>
                <th><?= __t('Tytuł', array(), 'fm'); ?></th>
                <th><?= __t('Operacja', array(), 'fm'); ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($pager->getResults() as $order => $element) : ?>
                <tr>
                    <td>
                        <?php include_partial('frontendManagement/articlePhotoListShow', array('photo' => $element)); ?>
                    </td>
                    <td><?= artStringConverter::addOnly3Dotes($element->getTitle(), 100); ?></td>
                    <td style="vertical-align: middle; min-width: 100px;">
                        <button type="button" class="btn btn-primary" onclick="ManageForm.startIndicator(ManageForm.getPopupContent());
                                ManageForm.articlePhotoEdit(this, '<?= $element->getId(); ?>');"><i class="icon-edit"></i> <?= __('Edytuj'); ?></button>
                        <button type="button" class="btn btn-danger" onclick="ManageForm.startIndicator(ManageForm.getPopupContent());
                                ManageForm.articlePhotoDelete(this, '<?= $element->getId(); ?>');"><i class="icon-trash"></i> <?= __('Usuń'); ?></button>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

    <?php if ($pager->haveToPaginate()) : ?>
        <div class="pagination">
            <ul>
                <?php foreach ($pager->getLinks() as $page) : ?>
                    <li class="<?= ($page == $pager->getPage() ? 'active' : ''); ?>"><a href="#" onclick="ManageForm.startIndicator(ManageForm.getPopupContent());
                            ManageForm.articlePhotoList(this, '<?= $requestParameters['article_id']; ?>', '<?= $page; ?>');"><?= $page; ?></a></li>
                    <?php endforeach; ?>
            </ul>
        </div>
    <?php endif; ?>
<?php else : ?>
    <div class="row">
        <div class="col-md-12">
            <div class="alert alert-info">
                <?= __t('Brak wyników', array(), 'fm'); ?>
            </div>
        </div>
    </div>
<?php endif; ?>

<div class="row">
    <div class="col-md-4">
        <button data-dismiss="modal" class="btn btn-danger pull-left"><i class="megaicon1-x"></i> <?= __('Anuluj'); ?></button>
    </div>
    <?php if ($pager->getNbResults() > 0) : ?>
        <div class="col-md-4 col-md-offset-4">
            <button onclick="ManageForm.startIndicator(ManageForm.getPopupContent()); ManageForm.articlePhotoDeleteAll(this, \''.$requestParameters['article_id'].'\');" class="btn btn-danger pull-right"><i class="megaicon1-x"></i> <?= __('Usuń wszystkie zdjęcia'); ?></button>
        </div>
    <?php endif; ?>
</div>

<?php include_partial('frontendManagement/modal_end', $this->getAttributes()); ?>

